/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.dos.Dos_tables;
import jdos.gui.Main;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.ints.Int10_char;
import jdos.ints.Int10_modes;
import jdos.ints.Int10_put_pixel;
import jdos.misc.Log;
import jdos.misc.setup.Section;
import jdos.util.ShortRef;

public class Mouse {
    private static int call_int33;
    private static int call_int74;
    private static int int74_ret_callback;
    private static int call_mouse_bd;
    private static int ps2cbseg;
    private static int ps2cbofs;
    private static boolean useps2callback;
    private static boolean ps2callbackinit;
    private static int call_ps2;
    private static int ps2_callback;
    private static short oldmouseX;
    private static short oldmouseY;
    private static final int QUEUE_SIZE = 32;
    private static final int MOUSE_BUTTONS = 3;
    private static final int MOUSE_IRQ = 12;
    private static final int CURSORX = 16;
    private static final int CURSORY = 16;
    private static final int HIGHESTBIT = 32768;
    private static final int defaultTextAndMask = 30719;
    private static final int defaultTextXorMask = 30464;
    private static final int[] defaultScreenMask;
    private static final int[] defaultCursorMask;
    private static int[] userdefScreenMask;
    private static int[] userdefCursorMask;
    public static _mouse mouse;
    private static Callback.Handler PS2_Handler;
    private static final int X_MICKEY = 8;
    private static final int Y_MICKEY = 8;
    private static final int MOUSE_HAS_MOVED = 1;
    private static final int MOUSE_LEFT_PRESSED = 2;
    private static final int MOUSE_LEFT_RELEASED = 4;
    private static final int MOUSE_RIGHT_PRESSED = 8;
    private static final int MOUSE_RIGHT_RELEASED = 16;
    private static final int MOUSE_MIDDLE_PRESSED = 32;
    private static final int MOUSE_MIDDLE_RELEASED = 64;
    private static final float MOUSE_DELAY = 5.0f;
    private static Pic.PIC_EventHandler MOUSE_Limit_Events;
    static short[] gfxReg3CE;
    static short index3C4;
    static short gfxReg3C5;
    private static Callback.Handler INT33_Handler;
    private static Callback.Handler MOUSE_BD_Handler;
    private static Callback.Handler INT74_Handler;
    private static Callback.Handler MOUSE_UserInt_CB_Handler;
    public static Section.SectionFunction MOUSE_Destroy;
    public static Section.SectionFunction MOUSE_Init;

    public static short POS_X() {
        return (short)((short)Mouse.mouse.x & Mouse.mouse.granMask);
    }

    public static short POS_Y() {
        return (short)Mouse.mouse.y;
    }

    private static void write(DataOutputStream dos, int i) throws IOException {
        dos.writeInt(i);
    }

    private static void write(DataOutputStream dos, boolean i) throws IOException {
        dos.writeBoolean(i);
    }

    private static void write(DataOutputStream dos, short s) throws IOException {
        dos.writeShort(s);
    }

    private static void write(DataOutputStream dos, int[] a) throws IOException {
        for (int i = 0; i < a.length; ++i) {
            dos.writeInt(a[i]);
        }
    }

    public static boolean Mouse_SetPS2State(boolean use) {
        if (use && !ps2callbackinit) {
            useps2callback = false;
            Pic.PIC_SetIRQMask(12, true);
            return false;
        }
        useps2callback = use;
        Main.Mouse_AutoLock(useps2callback);
        Pic.PIC_SetIRQMask(12, !useps2callback);
        return true;
    }

    public static void Mouse_ChangePS2Callback(int pseg, int pofs) {
        if (pseg == 0 && pofs == 0) {
            ps2callbackinit = false;
            Main.Mouse_AutoLock(false);
        } else {
            ps2callbackinit = true;
            ps2cbseg = pseg;
            ps2cbofs = pofs;
        }
        Main.Mouse_AutoLock(ps2callbackinit);
    }

    private static void DoPS2Callback(int data, short mouseX, short mouseY) {
        if (useps2callback) {
            int mdat = data & 3 | 8;
            int xdiff = mouseX - oldmouseX;
            int ydiff = oldmouseY - mouseY;
            oldmouseX = mouseX;
            oldmouseY = mouseY;
            if (xdiff > 255 || xdiff < -255) {
                mdat |= 0x40;
            }
            if (ydiff > 255 || ydiff < -255) {
                mdat |= 0x80;
            }
            ydiff %= 256;
            if ((xdiff %= 256) < 0) {
                xdiff = 256 + xdiff;
                mdat |= 0x10;
            }
            if (ydiff < 0) {
                ydiff = 256 + ydiff;
                mdat |= 0x20;
            }
            CPU.CPU_Push16(mdat);
            CPU.CPU_Push16(xdiff % 256);
            CPU.CPU_Push16(ydiff % 256);
            CPU.CPU_Push16(0);
            CPU.CPU_Push16(Memory.RealSeg(ps2_callback));
            CPU.CPU_Push16(Memory.RealOff(ps2_callback));
            CPU_Regs.SegSet16CS(ps2cbseg);
            CPU_Regs.reg_ip(ps2cbofs);
        }
    }

    private static void Mouse_AddEvent(int type) {
        if (Mouse.mouse.events < 32) {
            if (Mouse.mouse.events > 0) {
                if (type == 1) {
                    return;
                }
                for (int i = Mouse.mouse.events; i != 0; --i) {
                    Mouse.mouse.event_queue[i] = Mouse.mouse.event_queue[i - 1];
                }
            }
            Mouse.mouse.event_queue[0].type = (short)type;
            Mouse.mouse.event_queue[0].buttons = Mouse.mouse.buttons;
            Mouse.mouse.events = (short)(Mouse.mouse.events + 1);
        }
        if (!Mouse.mouse.timer_in_progress) {
            Mouse.mouse.timer_in_progress = true;
            Pic.PIC_AddEvent(MOUSE_Limit_Events, 5.0f);
            Pic.PIC_ActivateIRQ(12);
        }
    }

    private static void RestoreCursorBackgroundText() {
        if (Mouse.mouse.hidden != 0 || Mouse.mouse.inhibit_draw) {
            return;
        }
        if (Mouse.mouse.background) {
            Int10_char.WriteChar(Mouse.mouse.backposx, Mouse.mouse.backposy, Memory.real_readb(64, 98), Mouse.mouse.backData[0], Mouse.mouse.backData[1], true);
            Mouse.mouse.background = false;
        }
    }

    private static void DrawCursorText() {
        Mouse.RestoreCursorBackgroundText();
        Mouse.mouse.backposx = (short)(Mouse.POS_X() >>> 3);
        Mouse.mouse.backposy = (short)(Mouse.POS_Y() >>> 3);
        short page = Memory.real_readb(64, 98);
        int result = Int10_char.ReadCharAttr(Mouse.mouse.backposx, Mouse.mouse.backposy, page);
        Mouse.mouse.backData[0] = (short)(result & 0xFF);
        Mouse.mouse.backData[1] = (short)(result >> 8);
        Mouse.mouse.background = true;
        result = result & Mouse.mouse.textAndMask ^ Mouse.mouse.textXorMask;
        Int10_char.WriteChar(Mouse.mouse.backposx, Mouse.mouse.backposy, page, (short)(result & 0xFF), (short)(result >> 8), true);
    }

    private static void SaveVgaRegisters() {
        if (Dosbox.IS_VGA_ARCH()) {
            for (int i = 0; i < 9; i = (int)((short)(i + 1))) {
                IoHandler.IO_Write(974, i);
                Mouse.gfxReg3CE[i] = IoHandler.IO_Read(975);
            }
            IoHandler.IO_Write(974, 3);
            IoHandler.IO_Write(975, 0);
            IoHandler.IO_Write(974, 5);
            IoHandler.IO_Write(975, gfxReg3CE[5] & 0xF0);
            index3C4 = IoHandler.IO_Read(964);
            IoHandler.IO_Write(964, 2);
            gfxReg3C5 = IoHandler.IO_Read(965);
            IoHandler.IO_Write(965, 15);
        } else if (Dosbox.machine == 4) {
            IoHandler.IO_Write(964, 2);
            IoHandler.IO_Write(965, 15);
        }
    }

    private static void RestoreVgaRegisters() {
        if (Dosbox.IS_VGA_ARCH()) {
            for (int i = 0; i < 9; i = (int)((short)(i + 1))) {
                IoHandler.IO_Write(974, i);
                IoHandler.IO_Write(975, gfxReg3CE[i]);
            }
            IoHandler.IO_Write(964, 2);
            IoHandler.IO_Write(965, gfxReg3C5);
            IoHandler.IO_Write(964, index3C4);
        }
    }

    private static void ClipCursorArea(ShortRef x1, ShortRef x2, ShortRef y1, ShortRef y2, ShortRef addx1, ShortRef addx2, ShortRef addy) {
        addy.value = 0;
        addx2.value = 0;
        addx1.value = 0;
        if (y1.value < 0) {
            addy.value = (short)(addy.value + -y1.value);
            y1.value = 0;
        }
        if (y2.value > Mouse.mouse.clipy) {
            y2.value = Mouse.mouse.clipy;
        }
        if (x1.value < 0) {
            addx1.value = (short)(addx1.value + -x1.value);
            x1.value = 0;
        }
        if (x2.value > Mouse.mouse.clipx) {
            addx2.value = (short)(x2.value - Mouse.mouse.clipx);
            x2.value = Mouse.mouse.clipx;
        }
    }

    private static void RestoreCursorBackground() {
        if (Mouse.mouse.hidden != 0 || Mouse.mouse.inhibit_draw) {
            return;
        }
        Mouse.SaveVgaRegisters();
        if (Mouse.mouse.background) {
            ShortRef addx1 = new ShortRef();
            ShortRef addx2 = new ShortRef();
            ShortRef addy = new ShortRef();
            int dataPos = 0;
            ShortRef x1 = new ShortRef(Mouse.mouse.backposx);
            ShortRef y1 = new ShortRef(Mouse.mouse.backposy);
            ShortRef x2 = new ShortRef(x1.value + 16 - 1);
            ShortRef y2 = new ShortRef(y1.value + 16 - 1);
            Mouse.ClipCursorArea(x1, x2, y1, y2, addx1, addx2, addy);
            dataPos = addy.value * 16;
            for (short y = y1.value; y <= y2.value; y = (short)(y + 1)) {
                dataPos += addx1.value;
                for (short x = x1.value; x <= x2.value; x = (short)(x + 1)) {
                    Int10_put_pixel.INT10_PutPixel(x, y, Mouse.mouse.page, Mouse.mouse.backData[dataPos++]);
                }
                dataPos += addx2.value;
            }
            Mouse.mouse.background = false;
        }
        Mouse.RestoreVgaRegisters();
    }

    private static void DrawCursor() {
        short x;
        short y;
        if (Mouse.mouse.hidden != 0 || Mouse.mouse.inhibit_draw) {
            return;
        }
        if (Int10_modes.CurMode.type == 9) {
            Mouse.DrawCursorText();
            return;
        }
        if (Memory.real_readb(64, 98) != Mouse.mouse.page) {
            return;
        }
        Mouse.mouse.clipx = (short)(Int10_modes.CurMode.swidth - 1);
        Mouse.mouse.clipy = (short)(Int10_modes.CurMode.sheight - 1);
        int xratio = 640;
        if (Int10_modes.CurMode.swidth > 0) {
            xratio = (short)(xratio / Int10_modes.CurMode.swidth);
        }
        if (xratio == 0) {
            xratio = 1;
        }
        Mouse.RestoreCursorBackground();
        Mouse.SaveVgaRegisters();
        ShortRef addx1 = new ShortRef();
        ShortRef addx2 = new ShortRef();
        ShortRef addy = new ShortRef();
        int dataPos = 0;
        ShortRef x1 = new ShortRef(Mouse.POS_X() / xratio - Mouse.mouse.hotx);
        ShortRef y1 = new ShortRef(Mouse.POS_Y() - Mouse.mouse.hoty);
        ShortRef x2 = new ShortRef(x1.value + 16 - 1);
        ShortRef y2 = new ShortRef(y1.value + 16 - 1);
        Mouse.ClipCursorArea(x1, x2, y1, y2, addx1, addx2, addy);
        dataPos = addy.value * 16;
        for (y = y1.value; y <= y2.value; y = (short)(y + 1)) {
            dataPos += addx1.value;
            for (x = x1.value; x <= x2.value; x = (short)(x + 1)) {
                Mouse.mouse.backData[dataPos++] = Int10_put_pixel.INT10_GetPixel(x, y, Mouse.mouse.page);
            }
            dataPos += addx2.value;
        }
        Mouse.mouse.background = true;
        Mouse.mouse.backposx = (short)(Mouse.POS_X() / xratio - Mouse.mouse.hotx);
        Mouse.mouse.backposy = (short)(Mouse.POS_Y() - Mouse.mouse.hoty);
        dataPos = addy.value * 16;
        for (y = y1.value; y <= y2.value; y = (short)(y + 1)) {
            int scMask = Mouse.mouse.screenMask[addy.value + y - y1.value];
            int cuMask = Mouse.mouse.cursorMask[addy.value + y - y1.value];
            if (addx1.value > 0) {
                scMask <<= addx1.value;
                cuMask <<= addx1.value;
                dataPos += addx1.value;
            }
            for (x = x1.value; x <= x2.value; x = (short)(x + 1)) {
                short pixel = 0;
                if ((scMask & 0x8000) != 0) {
                    pixel = Mouse.mouse.backData[dataPos];
                }
                scMask <<= 1;
                if ((cuMask & 0x8000) != 0) {
                    pixel = (short)(pixel ^ 0xF);
                }
                cuMask <<= 1;
                Int10_put_pixel.INT10_PutPixel(x, y, Mouse.mouse.page, pixel);
                ++dataPos;
            }
            dataPos += addx2.value;
        }
        Mouse.RestoreVgaRegisters();
    }

    public static void Mouse_CursorMoved(float xrel, float yrel, float x, float y, boolean emulate) {
        float dx = xrel * Mouse.mouse.pixelPerMickey_x;
        float dy = yrel * Mouse.mouse.pixelPerMickey_y;
        if ((double)Math.abs(xrel) > 1.0 || (double)Mouse.mouse.senv_x < 1.0) {
            dx *= Mouse.mouse.senv_x;
        }
        if ((double)Math.abs(yrel) > 1.0 || (double)Mouse.mouse.senv_y < 1.0) {
            dy *= Mouse.mouse.senv_y;
        }
        if (useps2callback) {
            dy *= 2.0f;
        }
        Mouse.mouse.mickey_x += dx;
        Mouse.mouse.mickey_y += dy;
        if (emulate) {
            Mouse.mouse.x += dx;
            Mouse.mouse.y += dy;
        } else if (Int10_modes.CurMode.type == 9) {
            Mouse.mouse.x = x * (float)Int10_modes.CurMode.swidth;
            Mouse.mouse.y = y * (float)Int10_modes.CurMode.sheight * 8.0f / (float)Int10_modes.CurMode.cheight;
        } else if (Mouse.mouse.max_x < 2048 || Mouse.mouse.max_y < 2048 || Mouse.mouse.max_x != Mouse.mouse.max_y) {
            if (Mouse.mouse.max_x > 0 && Mouse.mouse.max_y > 0) {
                Mouse.mouse.x = x * (float)Mouse.mouse.max_x;
                Mouse.mouse.y = y * (float)Mouse.mouse.max_y;
            } else {
                Mouse.mouse.x += xrel;
                Mouse.mouse.y += yrel;
            }
        } else {
            Mouse.mouse.x += xrel;
            Mouse.mouse.y += yrel;
        }
        if (!useps2callback) {
            if (Mouse.mouse.x > (float)Mouse.mouse.max_x) {
                Mouse.mouse.x = Mouse.mouse.max_x;
            }
            if (Mouse.mouse.x < (float)Mouse.mouse.min_x) {
                Mouse.mouse.x = Mouse.mouse.min_x;
            }
            if (Mouse.mouse.y > (float)Mouse.mouse.max_y) {
                Mouse.mouse.y = Mouse.mouse.max_y;
            }
            if (Mouse.mouse.y < (float)Mouse.mouse.min_y) {
                Mouse.mouse.y = Mouse.mouse.min_y;
            }
        }
        Mouse.Mouse_AddEvent(1);
        Mouse.DrawCursor();
    }

    private static void Mouse_CursorSet(float x, float y) {
        Mouse.mouse.x = x;
        Mouse.mouse.y = y;
        Mouse.DrawCursor();
    }

    public static void Mouse_ButtonPressed(int button) {
        switch (button) {
            case 0: {
                Mouse.mouse.buttons = (short)(Mouse.mouse.buttons | 1);
                Mouse.Mouse_AddEvent(2);
                break;
            }
            case 1: {
                Mouse.mouse.buttons = (short)(Mouse.mouse.buttons | 2);
                Mouse.Mouse_AddEvent(8);
                break;
            }
            case 2: {
                Mouse.mouse.buttons = (short)(Mouse.mouse.buttons | 4);
                Mouse.Mouse_AddEvent(32);
                break;
            }
            default: {
                return;
            }
        }
        int n = button;
        Mouse.mouse.times_pressed[n] = Mouse.mouse.times_pressed[n] + 1;
        Mouse.mouse.last_pressed_x[button] = Mouse.POS_X();
        Mouse.mouse.last_pressed_y[button] = Mouse.POS_Y();
    }

    public static void Mouse_ButtonReleased(int button) {
        switch (button) {
            case 0: {
                Mouse.mouse.buttons = (short)(Mouse.mouse.buttons & 0xFFFFFFFE);
                Mouse.Mouse_AddEvent(4);
                break;
            }
            case 1: {
                Mouse.mouse.buttons = (short)(Mouse.mouse.buttons & 0xFFFFFFFD);
                Mouse.Mouse_AddEvent(16);
                break;
            }
            case 2: {
                Mouse.mouse.buttons = (short)(Mouse.mouse.buttons & 0xFFFFFFFB);
                Mouse.Mouse_AddEvent(64);
                break;
            }
            default: {
                return;
            }
        }
        int n = button;
        Mouse.mouse.times_released[n] = Mouse.mouse.times_released[n] + 1;
        Mouse.mouse.last_released_x[button] = Mouse.POS_X();
        Mouse.mouse.last_released_y[button] = Mouse.POS_Y();
    }

    private static void Mouse_SetMickeyPixelRate(int px, int py) {
        if (px != 0 && py != 0) {
            Mouse.mouse.mickeysPerPixel_x = (float)px / 8.0f;
            Mouse.mouse.mickeysPerPixel_y = (float)py / 8.0f;
            Mouse.mouse.pixelPerMickey_x = 8.0f / (float)px;
            Mouse.mouse.pixelPerMickey_y = 8.0f / (float)py;
        }
    }

    private static void Mouse_SetSensitivity(int px, int py, int dspeed) {
        if (px > 100) {
            px = 100;
        }
        if (py > 100) {
            py = 100;
        }
        if (dspeed > 100) {
            dspeed = 100;
        }
        Mouse.mouse.senv_x_val = px;
        Mouse.mouse.senv_y_val = py;
        Mouse.mouse.dspeed_val = dspeed;
        if (px != 0 && py != 0) {
            Mouse.mouse.senv_x = (float)(--px) * (float)px / 3600.0f + 0.33333334f;
            Mouse.mouse.senv_y = (float)(--py) * (float)py / 3600.0f + 0.33333334f;
        }
    }

    private static void Mouse_ResetHardware() {
        Pic.PIC_SetIRQMask(12, false);
    }

    public static void Mouse_NewVideoMode() {
        Mouse.mouse.inhibit_draw = false;
        short mode = Memory.mem_readb(1097);
        if (mode == Mouse.mouse.mode) {
            // empty if block
        }
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int rows = Memory.real_readb(64, 132);
                if (rows == 0 || rows > 250) {
                    rows = 24;
                }
                Mouse.mouse.max_y = (short)(8 * (rows + 1) - 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 19: {
                Mouse.mouse.max_y = (short)199;
                break;
            }
            case 15: 
            case 16: {
                Mouse.mouse.max_y = (short)349;
                break;
            }
            case 17: 
            case 18: {
                Mouse.mouse.max_y = (short)479;
                break;
            }
            default: {
                Log.log(18, 2, "Unhandled videomode " + Integer.toString(mode, 16) + " on reset");
                Mouse.mouse.inhibit_draw = true;
                return;
            }
        }
        Mouse.mouse.mode = mode;
        Mouse.mouse.hidden = 1;
        Mouse.mouse.max_x = (short)639;
        Mouse.mouse.min_x = 0;
        Mouse.mouse.min_y = 0;
        Mouse.mouse.granMask = (short)(mode == 13 || mode == 19 ? 65534 : 65535);
        Mouse.mouse.events = 0;
        Mouse.mouse.timer_in_progress = false;
        Pic.PIC_RemoveEvents(MOUSE_Limit_Events);
        Mouse.mouse.hotx = 0;
        Mouse.mouse.hoty = 0;
        Mouse.mouse.background = false;
        Mouse.mouse.screenMask = defaultScreenMask;
        Mouse.mouse.cursorMask = defaultCursorMask;
        Mouse.mouse.textAndMask = 30719;
        Mouse.mouse.textXorMask = 30464;
        Mouse.mouse.language = 0;
        Mouse.mouse.page = 0;
        Mouse.mouse.doubleSpeedThreshold = 64;
        Mouse.mouse.updateRegion_x[0] = 1;
        Mouse.mouse.updateRegion_y[0] = 1;
        Mouse.mouse.updateRegion_x[1] = 1;
        Mouse.mouse.updateRegion_y[1] = 1;
        Mouse.mouse.cursorType = 0;
        Mouse.mouse.enabled = true;
        Mouse.mouse.oldhidden = 1;
        oldmouseX = (short)Mouse.mouse.x;
        oldmouseY = (short)Mouse.mouse.y;
    }

    private static void Mouse_Reset() {
        if (Int10_modes.CurMode.type != 9) {
            Mouse.RestoreCursorBackground();
        } else {
            Mouse.RestoreCursorBackgroundText();
        }
        Mouse.mouse.hidden = 1;
        Mouse.Mouse_NewVideoMode();
        Mouse.Mouse_SetMickeyPixelRate(8, 16);
        Mouse.mouse.mickey_x = 0.0f;
        Mouse.mouse.mickey_y = 0.0f;
        Mouse.mouse.x = (Mouse.mouse.max_x + 1) / 2;
        Mouse.mouse.y = (Mouse.mouse.max_y + 1) / 2;
        Mouse.mouse.sub_mask = 0;
        Mouse.mouse.in_UIR = false;
    }

    static {
        defaultScreenMask = new int[]{16383, 8191, 4095, 2047, 1023, 511, 255, 127, 63, 31, 511, 255, 12543, 63615, 63615, 64767};
        defaultCursorMask = new int[]{0, 16384, 24576, 28672, 30720, 31744, 32256, 32512, 32640, 31744, 27648, 17920, 1536, 768, 768, 0};
        userdefScreenMask = new int[16];
        userdefCursorMask = new int[16];
        mouse = new _mouse();
        PS2_Handler = new Callback.Handler(){

            public String getName() {
                return "Mouse.PS2_Handler";
            }

            public int call() {
                CPU.CPU_Pop16();
                CPU.CPU_Pop16();
                CPU.CPU_Pop16();
                CPU.CPU_Pop16();
                return 0;
            }
        };
        MOUSE_Limit_Events = new Pic.PIC_EventHandler(){

            public void call(int val) {
                Mouse.mouse.timer_in_progress = false;
                if (Mouse.mouse.events != 0) {
                    Mouse.mouse.timer_in_progress = true;
                    Pic.PIC_AddEvent(MOUSE_Limit_Events, 5.0f);
                    Pic.PIC_ActivateIRQ(12);
                }
            }

            public String toString() {
                return "MOUSE_Limit_Events";
            }
        };
        gfxReg3CE = new short[9];
        INT33_Handler = new Callback.Handler(){

            public String getName() {
                return "Mouse.INT33_Handler";
            }

            public int call() {
                switch (CPU_Regs.reg_eax.word()) {
                    case 0: {
                        Mouse.Mouse_ResetHardware();
                    }
                    case 33: {
                        CPU_Regs.reg_eax.word(65535);
                        CPU_Regs.reg_ebx.word(3);
                        Mouse.Mouse_Reset();
                        Main.Mouse_AutoLock(true);
                        break;
                    }
                    case 1: {
                        if (Mouse.mouse.hidden != 0) {
                            --Mouse.mouse.hidden;
                        }
                        Main.Mouse_AutoLock(true);
                        Mouse.DrawCursor();
                        break;
                    }
                    case 2: {
                        if (Int10_modes.CurMode.type != 9) {
                            Mouse.RestoreCursorBackground();
                        } else {
                            Mouse.RestoreCursorBackgroundText();
                        }
                        ++Mouse.mouse.hidden;
                        break;
                    }
                    case 3: {
                        CPU_Regs.reg_ebx.word(Mouse.mouse.buttons);
                        CPU_Regs.reg_ecx.word(Mouse.POS_X());
                        CPU_Regs.reg_edx.word(Mouse.POS_Y());
                        break;
                    }
                    case 4: {
                        if ((short)CPU_Regs.reg_ecx.word() >= Mouse.mouse.max_x) {
                            Mouse.mouse.x = Mouse.mouse.max_x;
                        } else if (Mouse.mouse.min_x >= CPU_Regs.reg_ecx.word()) {
                            Mouse.mouse.x = Mouse.mouse.min_x;
                        } else if (CPU_Regs.reg_ecx.word() != Mouse.POS_X()) {
                            Mouse.mouse.x = CPU_Regs.reg_ecx.word();
                        }
                        if ((short)CPU_Regs.reg_edx.word() >= Mouse.mouse.max_y) {
                            Mouse.mouse.y = Mouse.mouse.max_y;
                        } else if (Mouse.mouse.min_y >= (short)CPU_Regs.reg_edx.word()) {
                            Mouse.mouse.y = Mouse.mouse.min_y;
                        } else if ((short)CPU_Regs.reg_edx.word() != Mouse.POS_Y()) {
                            Mouse.mouse.y = CPU_Regs.reg_edx.word();
                        }
                        Mouse.DrawCursor();
                        break;
                    }
                    case 5: {
                        int but = CPU_Regs.reg_ebx.word();
                        CPU_Regs.reg_eax.word(Mouse.mouse.buttons);
                        if (but >= 3) {
                            but = 2;
                        }
                        CPU_Regs.reg_ecx.word(Mouse.mouse.last_pressed_x[but]);
                        CPU_Regs.reg_edx.word(Mouse.mouse.last_pressed_y[but]);
                        CPU_Regs.reg_ebx.word(Mouse.mouse.times_pressed[but]);
                        Mouse.mouse.times_pressed[but] = 0;
                        break;
                    }
                    case 6: {
                        int but = CPU_Regs.reg_ebx.word();
                        CPU_Regs.reg_eax.word(Mouse.mouse.buttons);
                        if (but >= 3) {
                            but = 2;
                        }
                        CPU_Regs.reg_ecx.word(Mouse.mouse.last_released_x[but]);
                        CPU_Regs.reg_edx.word(Mouse.mouse.last_released_y[but]);
                        CPU_Regs.reg_ebx.word(Mouse.mouse.times_released[but]);
                        Mouse.mouse.times_released[but] = 0;
                        break;
                    }
                    case 7: {
                        short max;
                        short min;
                        if ((short)CPU_Regs.reg_ecx.word() < (short)CPU_Regs.reg_edx.word()) {
                            min = (short)CPU_Regs.reg_ecx.word();
                            max = (short)CPU_Regs.reg_edx.word();
                        } else {
                            min = (short)CPU_Regs.reg_edx.word();
                            max = (short)CPU_Regs.reg_ecx.word();
                        }
                        Mouse.mouse.min_x = min;
                        Mouse.mouse.max_x = max;
                        if (Mouse.mouse.x > (float)Mouse.mouse.max_x) {
                            Mouse.mouse.x = Mouse.mouse.max_x;
                        }
                        if (!(Mouse.mouse.x < (float)Mouse.mouse.min_x)) break;
                        Mouse.mouse.x = Mouse.mouse.min_x;
                        break;
                    }
                    case 8: {
                        short max;
                        short min;
                        if ((short)CPU_Regs.reg_ecx.word() < (short)CPU_Regs.reg_edx.word()) {
                            min = (short)CPU_Regs.reg_ecx.word();
                            max = (short)CPU_Regs.reg_edx.word();
                        } else {
                            min = (short)CPU_Regs.reg_edx.word();
                            max = (short)CPU_Regs.reg_ecx.word();
                        }
                        Mouse.mouse.min_y = min;
                        Mouse.mouse.max_y = max;
                        if (Mouse.mouse.y > (float)Mouse.mouse.max_y) {
                            Mouse.mouse.y = Mouse.mouse.max_y;
                        }
                        if (!(Mouse.mouse.y < (float)Mouse.mouse.min_y)) break;
                        Mouse.mouse.y = Mouse.mouse.min_y;
                        break;
                    }
                    case 9: {
                        int src = CPU.Segs_ESphys + CPU_Regs.reg_edx.word();
                        Memory.MEM_BlockRead16u(src, userdefScreenMask, 0, 16);
                        Memory.MEM_BlockRead16u(src + 32, userdefCursorMask, 0, 16);
                        Mouse.mouse.screenMask = userdefScreenMask;
                        Mouse.mouse.cursorMask = userdefCursorMask;
                        Mouse.mouse.hotx = (short)CPU_Regs.reg_ebx.word();
                        Mouse.mouse.hoty = (short)CPU_Regs.reg_ecx.word();
                        Mouse.mouse.cursorType = 2;
                        Mouse.DrawCursor();
                        break;
                    }
                    case 10: {
                        Mouse.mouse.cursorType = CPU_Regs.reg_ebx.word();
                        Mouse.mouse.textAndMask = CPU_Regs.reg_ecx.word();
                        Mouse.mouse.textXorMask = CPU_Regs.reg_edx.word();
                        break;
                    }
                    case 11: {
                        CPU_Regs.reg_ecx.word((short)(Mouse.mouse.mickey_x * Mouse.mouse.mickeysPerPixel_x));
                        CPU_Regs.reg_edx.word((short)(Mouse.mouse.mickey_y * Mouse.mouse.mickeysPerPixel_y));
                        Mouse.mouse.mickey_x = 0.0f;
                        Mouse.mouse.mickey_y = 0.0f;
                        break;
                    }
                    case 12: {
                        Mouse.mouse.sub_mask = CPU_Regs.reg_ecx.word();
                        Mouse.mouse.sub_seg = CPU.Segs_ESval;
                        Mouse.mouse.sub_ofs = CPU_Regs.reg_edx.word();
                        Main.Mouse_AutoLock(true);
                        break;
                    }
                    case 15: {
                        Mouse.Mouse_SetMickeyPixelRate(CPU_Regs.reg_ecx.word(), CPU_Regs.reg_edx.word());
                        break;
                    }
                    case 16: {
                        Mouse.mouse.updateRegion_x[0] = CPU_Regs.reg_ecx.word();
                        Mouse.mouse.updateRegion_y[0] = CPU_Regs.reg_edx.word();
                        Mouse.mouse.updateRegion_x[1] = CPU_Regs.reg_esi.word();
                        Mouse.mouse.updateRegion_y[1] = CPU_Regs.reg_edi.word();
                        break;
                    }
                    case 17: {
                        CPU_Regs.reg_eax.word(65535);
                        CPU_Regs.reg_ebx.word(3);
                        break;
                    }
                    case 19: {
                        Mouse.mouse.doubleSpeedThreshold = CPU_Regs.reg_ebx.word() != 0 ? CPU_Regs.reg_ebx.word() : 64;
                        break;
                    }
                    case 20: {
                        int oldSeg = Mouse.mouse.sub_seg;
                        int oldOfs = Mouse.mouse.sub_ofs;
                        int oldMask = Mouse.mouse.sub_mask;
                        Mouse.mouse.sub_mask = CPU_Regs.reg_ecx.word();
                        Mouse.mouse.sub_seg = CPU.Segs_ESval;
                        Mouse.mouse.sub_ofs = CPU_Regs.reg_edx.word();
                        CPU_Regs.reg_ecx.word(oldMask);
                        CPU_Regs.reg_edx.word(oldOfs);
                        CPU_Regs.SegSet16ES(oldSeg);
                        break;
                    }
                    case 21: {
                        CPU_Regs.reg_ebx.word(_mouse.sizeof());
                        break;
                    }
                    case 22: {
                        Log.log(18, 1, "Saving driver state...");
                        int dest = CPU.Segs_ESphys + CPU_Regs.reg_edx.word();
                        byte[] data = mouse.save();
                        Memory.MEM_BlockWrite(dest, data, data.length);
                        break;
                    }
                    case 23: {
                        Log.log(18, 1, "Loading driver state...");
                        int src = CPU.Segs_ESphys + CPU_Regs.reg_edx.word();
                        byte[] data = new byte[_mouse.sizeof()];
                        Memory.MEM_BlockRead(src, data, data.length);
                        mouse.load(data);
                        break;
                    }
                    case 26: {
                        Mouse.Mouse_SetSensitivity(CPU_Regs.reg_ebx.word(), CPU_Regs.reg_ecx.word(), CPU_Regs.reg_edx.word());
                        Log.log(18, 1, "Set sensitivity used with " + CPU_Regs.reg_ebx.word() + " " + CPU_Regs.reg_ecx.word() + " (" + CPU_Regs.reg_edx.word() + ")");
                        break;
                    }
                    case 27: {
                        CPU_Regs.reg_ebx.word(Mouse.mouse.senv_x_val);
                        CPU_Regs.reg_ecx.word(Mouse.mouse.senv_y_val);
                        CPU_Regs.reg_edx.word(Mouse.mouse.dspeed_val);
                        Log.log(18, 1, "Get sensitivity " + CPU_Regs.reg_ebx.word() + " " + CPU_Regs.reg_ecx.word());
                        break;
                    }
                    case 28: {
                        break;
                    }
                    case 29: {
                        Mouse.mouse.page = CPU_Regs.reg_ebx.low();
                        break;
                    }
                    case 30: {
                        CPU_Regs.reg_ebx.word(Mouse.mouse.page);
                        break;
                    }
                    case 31: {
                        CPU_Regs.reg_ebx.word(0);
                        CPU_Regs.SegSet16ES(0);
                        Mouse.mouse.enabled = false;
                        Mouse.mouse.oldhidden = Mouse.mouse.hidden;
                        Mouse.mouse.hidden = 1;
                        break;
                    }
                    case 32: {
                        Mouse.mouse.enabled = true;
                        Mouse.mouse.hidden = Mouse.mouse.oldhidden;
                        break;
                    }
                    case 34: {
                        Mouse.mouse.language = CPU_Regs.reg_ebx.word();
                        break;
                    }
                    case 35: {
                        CPU_Regs.reg_ebx.word(Mouse.mouse.language);
                        break;
                    }
                    case 36: {
                        CPU_Regs.reg_ebx.word(2053);
                        CPU_Regs.reg_ecx.high(4);
                        CPU_Regs.reg_ecx.low(0);
                        break;
                    }
                    case 38: {
                        CPU_Regs.reg_ebx.word(Mouse.mouse.enabled ? 0 : 65535);
                        CPU_Regs.reg_ecx.word(Mouse.mouse.max_x);
                        CPU_Regs.reg_edx.word(Mouse.mouse.max_y);
                        break;
                    }
                    case 49: {
                        CPU_Regs.reg_eax.word(Mouse.mouse.min_x);
                        CPU_Regs.reg_ebx.word(Mouse.mouse.min_y);
                        CPU_Regs.reg_ecx.word(Mouse.mouse.max_x);
                        CPU_Regs.reg_edx.word(Mouse.mouse.max_y);
                        break;
                    }
                    default: {
                        Log.log(18, 2, "Mouse Function " + Integer.toString(CPU_Regs.reg_eax.word(), 16) + " not implemented!");
                    }
                }
                return 0;
            }
        };
        MOUSE_BD_Handler = new Callback.Handler(){

            public String getName() {
                return "Mouse.MOUSE_BD_Handler";
            }

            public int call() {
                int raxpt = Memory.real_readw(CPU.Segs_SSval, CPU_Regs.reg_esp.word() + 10);
                int rbxpt = Memory.real_readw(CPU.Segs_SSval, CPU_Regs.reg_esp.word() + 8);
                int rcxpt = Memory.real_readw(CPU.Segs_SSval, CPU_Regs.reg_esp.word() + 6);
                int rdxpt = Memory.real_readw(CPU.Segs_SSval, CPU_Regs.reg_esp.word() + 4);
                int rax = Memory.real_readw(CPU.Segs_DSval, raxpt);
                CPU_Regs.reg_eax.word(rax);
                CPU_Regs.reg_ebx.word(Memory.real_readw(CPU.Segs_DSval, rbxpt));
                CPU_Regs.reg_ecx.word(Memory.real_readw(CPU.Segs_DSval, rcxpt));
                CPU_Regs.reg_edx.word(Memory.real_readw(CPU.Segs_DSval, rdxpt));
                switch (rax) {
                    case 9: 
                    case 22: 
                    case 23: {
                        CPU_Regs.SegSet16ES(CPU.Segs_DSval);
                        break;
                    }
                    case 12: 
                    case 20: {
                        if (CPU_Regs.reg_ebx.word() != 0) {
                            CPU_Regs.SegSet16ES(CPU_Regs.reg_ebx.word());
                            break;
                        }
                        CPU_Regs.SegSet16ES(CPU.Segs_DSval);
                        break;
                    }
                    case 16: {
                        CPU_Regs.reg_ecx.word(Memory.real_readw(CPU.Segs_DSval, rdxpt));
                        CPU_Regs.reg_edx.word(Memory.real_readw(CPU.Segs_DSval, rdxpt + 2));
                        CPU_Regs.reg_esi.word(Memory.real_readw(CPU.Segs_DSval, rdxpt + 4));
                        CPU_Regs.reg_edi.word(Memory.real_readw(CPU.Segs_DSval, rdxpt + 6));
                        break;
                    }
                }
                INT33_Handler.call();
                Memory.real_writew(CPU.Segs_DSval, raxpt, CPU_Regs.reg_eax.word());
                Memory.real_writew(CPU.Segs_DSval, rbxpt, CPU_Regs.reg_ebx.word());
                Memory.real_writew(CPU.Segs_DSval, rcxpt, CPU_Regs.reg_ecx.word());
                Memory.real_writew(CPU.Segs_DSval, rdxpt, CPU_Regs.reg_edx.word());
                switch (rax) {
                    case 31: {
                        Memory.real_writew(CPU.Segs_DSval, rbxpt, CPU.Segs_ESval);
                        break;
                    }
                    case 20: {
                        Memory.real_writew(CPU.Segs_DSval, rcxpt, CPU.Segs_ESval);
                        break;
                    }
                }
                CPU_Regs.reg_eax.word(rax);
                return 0;
            }
        };
        INT74_Handler = new Callback.Handler(){

            public String getName() {
                return "Mouse.INT74_Handler";
            }

            public int call() {
                if (Mouse.mouse.events > 0) {
                    Mouse.mouse.events = (short)(Mouse.mouse.events - 1);
                    if ((Mouse.mouse.sub_mask & Mouse.mouse.event_queue[Mouse.mouse.events].type) != 0) {
                        CPU_Regs.reg_eax.word(Mouse.mouse.event_queue[Mouse.mouse.events].type);
                        CPU_Regs.reg_ebx.word(Mouse.mouse.event_queue[Mouse.mouse.events].buttons);
                        CPU_Regs.reg_ecx.word(Mouse.POS_X());
                        CPU_Regs.reg_edx.word(Mouse.POS_Y());
                        CPU_Regs.reg_esi.word((short)(Mouse.mouse.mickey_x * Mouse.mouse.mickeysPerPixel_x));
                        CPU_Regs.reg_edi.word((short)(Mouse.mouse.mickey_y * Mouse.mouse.mickeysPerPixel_y));
                        CPU.CPU_Push16(Memory.RealSeg(Callback.CALLBACK_RealPointer(int74_ret_callback)));
                        CPU.CPU_Push16(Memory.RealOff(Callback.CALLBACK_RealPointer(int74_ret_callback)));
                        CPU_Regs.SegSet16CS(Mouse.mouse.sub_seg);
                        CPU_Regs.reg_ip(Mouse.mouse.sub_ofs);
                        if (Mouse.mouse.in_UIR) {
                            Log.log(18, 2, "Already in UIR!");
                        }
                        Mouse.mouse.in_UIR = true;
                    } else if (useps2callback) {
                        CPU.CPU_Push16(Memory.RealSeg(Callback.CALLBACK_RealPointer(int74_ret_callback)));
                        CPU.CPU_Push16(Memory.RealOff(Callback.CALLBACK_RealPointer(int74_ret_callback)));
                        Mouse.DoPS2Callback(Mouse.mouse.event_queue[Mouse.mouse.events].buttons, Mouse.POS_X(), Mouse.POS_Y());
                    } else {
                        CPU_Regs.SegSet16CS(Memory.RealSeg(Callback.CALLBACK_RealPointer(int74_ret_callback)));
                        CPU_Regs.reg_ip(Memory.RealOff(Callback.CALLBACK_RealPointer(int74_ret_callback)));
                    }
                } else {
                    CPU_Regs.SegSet16CS(Memory.RealSeg(Callback.CALLBACK_RealPointer(int74_ret_callback)));
                    CPU_Regs.reg_ip(Memory.RealOff(Callback.CALLBACK_RealPointer(int74_ret_callback)));
                }
                return 0;
            }
        };
        MOUSE_UserInt_CB_Handler = new Callback.Handler(){

            public String getName() {
                return "Mouse.MOUSE_UserInt_CB_Handler";
            }

            public int call() {
                Mouse.mouse.in_UIR = false;
                if (Mouse.mouse.events != 0 && !Mouse.mouse.timer_in_progress) {
                    Mouse.mouse.timer_in_progress = true;
                    Pic.PIC_AddEvent(MOUSE_Limit_Events, 5.0f);
                }
                return 0;
            }
        };
        MOUSE_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                mouse = new _mouse();
            }
        };
        MOUSE_Init = new Section.SectionFunction(){

            public void call(Section section) {
                call_int33 = Callback.CALLBACK_Allocate();
                int i33loc = Memory.RealMake(Dos_tables.DOS_GetMemory(1) - 1, 16);
                Callback.CALLBACK_Setup(call_int33, INT33_Handler, 13, Memory.Real2Phys(i33loc), "Mouse");
                Memory.real_writed(0, 204, i33loc);
                call_mouse_bd = Callback.CALLBACK_Allocate();
                Callback.CALLBACK_Setup(call_mouse_bd, MOUSE_BD_Handler, 2, Memory.PhysMake(Memory.RealSeg(i33loc), Memory.RealOff(i33loc) + 2), "MouseBD");
                call_int74 = Callback.CALLBACK_Allocate();
                Callback.CALLBACK_Setup(call_int74, INT74_Handler, 10, "int 74");
                int74_ret_callback = Callback.CALLBACK_Allocate();
                Callback.CALLBACK_Setup(int74_ret_callback, MOUSE_UserInt_CB_Handler, 11, "int 74 ret");
                int hwvec = 116;
                Memory.RealSetVec(hwvec, Callback.CALLBACK_RealPointer(call_int74));
                useps2callback = false;
                ps2callbackinit = false;
                call_ps2 = Callback.CALLBACK_Allocate();
                Callback.CALLBACK_Setup(call_ps2, PS2_Handler, 1, "ps2 bios callback");
                ps2_callback = Callback.CALLBACK_RealPointer(call_ps2);
                Mouse.mouse.hidden = 1;
                Mouse.mouse.timer_in_progress = false;
                Mouse.mouse.mode = (short)255;
                Mouse.mouse.sub_mask = 0;
                Mouse.mouse.sub_seg = 25442;
                Mouse.mouse.sub_ofs = 0;
                Mouse.Mouse_ResetHardware();
                Mouse.Mouse_Reset();
                Mouse.Mouse_SetSensitivity(50, 50, 50);
                section.AddDestroyFunction(MOUSE_Destroy, false);
            }
        };
    }

    public static class _mouse {
        private static int[][] maskholder = new int[128][];
        short buttons;
        int[] times_pressed = new int[3];
        int[] times_released = new int[3];
        int[] last_released_x = new int[3];
        int[] last_released_y = new int[3];
        int[] last_pressed_x = new int[3];
        int[] last_pressed_y = new int[3];
        int hidden;
        float add_x;
        float add_y;
        public short min_x;
        public short max_x;
        public short min_y;
        public short max_y;
        float mickey_x;
        float mickey_y;
        public float x;
        public float y;
        button_event[] event_queue = new button_event[32];
        short events;
        int sub_seg;
        int sub_ofs;
        int sub_mask;
        boolean background;
        short backposx;
        short backposy;
        short[] backData = new short[256];
        int[] screenMask;
        int[] cursorMask;
        short clipx;
        short clipy;
        short hotx;
        short hoty;
        int textAndMask;
        int textXorMask;
        float mickeysPerPixel_x;
        float mickeysPerPixel_y;
        float pixelPerMickey_x;
        float pixelPerMickey_y;
        int senv_x_val;
        int senv_y_val;
        int dspeed_val;
        float senv_x;
        float senv_y;
        int[] updateRegion_x = new int[2];
        int[] updateRegion_y = new int[2];
        int doubleSpeedThreshold;
        int language;
        int cursorType;
        int oldhidden;
        short page;
        boolean enabled;
        boolean inhibit_draw;
        boolean timer_in_progress;
        boolean in_UIR;
        short mode;
        short granMask;

        public _mouse() {
            for (int i = 0; i < this.event_queue.length; ++i) {
                this.event_queue[i] = new button_event();
            }
        }

        private void write16u(DataOutputStream os, int[] d) throws IOException {
            for (int i = 0; i < d.length; ++i) {
                os.writeShort(d[i] & 0xFFFF);
            }
        }

        private void write16u(DataOutputStream os, int d) throws IOException {
            os.writeShort(d & 0xFFFF);
        }

        private void write16s(DataOutputStream os, short d) throws IOException {
            os.writeShort(d);
        }

        private void write(DataOutputStream os, float d) throws IOException {
            os.writeFloat(d);
        }

        private void write8u(DataOutputStream os, short d) throws IOException {
            os.write(d & 0xFF);
        }

        private void write8u(DataOutputStream os, short[] d) throws IOException {
            for (int i = 0; i < d.length; ++i) {
                os.write(d[i] & 0xFF);
            }
        }

        private void writeBool(DataOutputStream os, boolean b) throws IOException {
            os.writeBoolean(b);
        }

        private void write16uPtr(DataOutputStream os, int[] d) throws IOException {
            for (int i = 1; i < maskholder.length; ++i) {
                if (maskholder[i] != null) continue;
                _mouse.maskholder[i] = d;
                os.writeInt(i);
                return;
            }
            Log.exit("Failed to save mouse state");
        }

        private void read16u(DataInputStream is, int[] d) throws IOException {
            for (int i = 0; i < d.length; ++i) {
                d[i] = is.readUnsignedShort();
            }
        }

        private int read16u(DataInputStream is) throws IOException {
            return is.readUnsignedShort();
        }

        private short read16s(DataInputStream is) throws IOException {
            return is.readShort();
        }

        private float readFloat(DataInputStream is) throws IOException {
            return is.readFloat();
        }

        private short read8u(DataInputStream is) throws IOException {
            return (short)is.readUnsignedByte();
        }

        private void read8u(DataInputStream is, short[] d) throws IOException {
            for (int i = 0; i < d.length; ++i) {
                d[i] = (short)is.readUnsignedByte();
            }
        }

        private boolean readBool(DataInputStream is) throws IOException {
            return is.readBoolean();
        }

        private int[] read16uPtr(DataInputStream is) throws IOException {
            int index = is.readInt();
            int[] result = maskholder[index];
            _mouse.maskholder[index] = null;
            return result;
        }

        public byte[] save() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream os = new DataOutputStream(bos);
                this.write8u(os, this.buttons);
                this.write16u(os, this.times_pressed);
                this.write16u(os, this.times_released);
                this.write16u(os, this.last_released_x);
                this.write16u(os, this.last_released_y);
                this.write16u(os, this.last_pressed_x);
                this.write16u(os, this.last_pressed_y);
                this.write16u(os, this.hidden);
                this.write(os, this.add_x);
                this.write(os, this.add_y);
                this.write16s(os, this.min_x);
                this.write16s(os, this.max_x);
                this.write16s(os, this.min_y);
                this.write16s(os, this.max_y);
                this.write(os, this.mickey_x);
                this.write(os, this.mickey_y);
                this.write(os, this.x);
                this.write(os, this.y);
                for (int i = 0; i < this.event_queue.length; ++i) {
                    this.write8u(os, this.event_queue[i].type);
                    this.write8u(os, this.event_queue[i].buttons);
                }
                this.write8u(os, this.events);
                this.write16u(os, this.sub_seg);
                this.write16u(os, this.sub_ofs);
                this.write16u(os, this.sub_mask);
                this.writeBool(os, this.background);
                this.write16s(os, this.backposx);
                this.write16s(os, this.backposy);
                this.write8u(os, this.backData);
                this.write16uPtr(os, this.screenMask);
                this.write16uPtr(os, this.cursorMask);
                this.write16s(os, this.clipx);
                this.write16s(os, this.clipy);
                this.write16s(os, this.hotx);
                this.write16s(os, this.hoty);
                this.write16u(os, this.textAndMask);
                this.write16u(os, this.textXorMask);
                this.write(os, this.mickeysPerPixel_x);
                this.write(os, this.mickeysPerPixel_y);
                this.write(os, this.pixelPerMickey_x);
                this.write(os, this.pixelPerMickey_y);
                this.write16u(os, this.senv_x_val);
                this.write16u(os, this.senv_y_val);
                this.write16u(os, this.dspeed_val);
                this.write(os, this.senv_x);
                this.write(os, this.senv_y);
                this.write16u(os, this.updateRegion_x);
                this.write16u(os, this.updateRegion_y);
                this.write16u(os, this.doubleSpeedThreshold);
                this.write16u(os, this.language);
                this.write16u(os, this.cursorType);
                this.write16u(os, this.oldhidden);
                this.write8u(os, this.page);
                this.writeBool(os, this.enabled);
                this.writeBool(os, this.inhibit_draw);
                this.writeBool(os, this.timer_in_progress);
                this.writeBool(os, this.in_UIR);
                this.write8u(os, this.mode);
                this.write16s(os, this.granMask);
                return bos.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
                return new byte[0];
            }
        }

        public void load(byte[] data) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                DataInputStream is = new DataInputStream(bis);
                this.buttons = this.read8u(is);
                this.read16u(is, this.times_pressed);
                this.read16u(is, this.times_released);
                this.read16u(is, this.last_released_x);
                this.read16u(is, this.last_released_y);
                this.read16u(is, this.last_pressed_x);
                this.read16u(is, this.last_pressed_y);
                this.hidden = this.read16u(is);
                this.add_x = this.readFloat(is);
                this.add_y = this.readFloat(is);
                this.min_x = this.read16s(is);
                this.max_x = this.read16s(is);
                this.min_y = this.read16s(is);
                this.max_y = this.read16s(is);
                this.mickey_x = this.readFloat(is);
                this.mickey_y = this.readFloat(is);
                this.x = this.readFloat(is);
                this.x = this.readFloat(is);
                for (int i = 0; i < this.event_queue.length; ++i) {
                    this.event_queue[i].type = this.read8u(is);
                    this.event_queue[i].buttons = this.read8u(is);
                }
                this.events = this.read8u(is);
                this.sub_seg = this.read16u(is);
                this.sub_ofs = this.read16u(is);
                this.sub_mask = this.read16u(is);
                this.background = this.readBool(is);
                this.backposx = this.read16s(is);
                this.backposy = this.read16s(is);
                this.read8u(is, this.backData);
                this.screenMask = this.read16uPtr(is);
                this.cursorMask = this.read16uPtr(is);
                this.clipx = this.read16s(is);
                this.clipy = this.read16s(is);
                this.hotx = this.read16s(is);
                this.hoty = this.read16s(is);
                this.textAndMask = this.read16u(is);
                this.textXorMask = this.read16u(is);
                this.mickeysPerPixel_x = this.readFloat(is);
                this.mickeysPerPixel_y = this.readFloat(is);
                this.pixelPerMickey_x = this.readFloat(is);
                this.pixelPerMickey_y = this.readFloat(is);
                this.senv_x_val = this.read16u(is);
                this.senv_y_val = this.read16u(is);
                this.dspeed_val = this.read16u(is);
                this.senv_x = this.readFloat(is);
                this.senv_y = this.readFloat(is);
                this.read16u(is, this.updateRegion_x);
                this.read16u(is, this.updateRegion_y);
                this.doubleSpeedThreshold = this.read16u(is);
                this.language = this.read16u(is);
                this.cursorType = this.read16u(is);
                this.oldhidden = this.read16u(is);
                this.page = this.read8u(is);
                this.enabled = this.readBool(is);
                this.inhibit_draw = this.readBool(is);
                this.timer_in_progress = this.readBool(is);
                this.in_UIR = this.readBool(is);
                this.mode = this.read8u(is);
                this.granMask = this.read16s(is);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static int sizeof() {
            return 484;
        }
    }

    private static class button_event {
        short type;
        short buttons;

        private button_event() {
        }
    }
}

