/*
 * Decompiled with CFR 0.152.
 */
package jdos.misc;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import jdos.util.BooleanRef;
import jdos.util.FileHelper;
import jdos.util.StringRef;

public class Cross {
    static final Pattern p = Pattern.compile(" \\([A-Za-z]:\\)");

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    public static boolean isCDRom(String path) {
        String label = Cross.getVolumeLabel(path).toLowerCase();
        return label.indexOf("bd-rom") >= 0 || label.indexOf("dvd") >= 0;
    }

    public static String getVolumeLabel(String path) {
        File file = new File(path);
        while (file.getParentFile() != null) {
            file = file.getParentFile();
        }
        FileSystemView v = FileSystemView.getFileSystemView();
        String full = v.getSystemDisplayName(file);
        int length = full.length();
        Matcher m = p.matcher(full);
        String chopped = m.find() ? full.substring(0, m.start()).trim() : full.trim();
        return chopped;
    }

    public static dir_information open_directory(String dirname) {
        if (!new File(dirname).exists()) {
            return null;
        }
        dir_information result = new dir_information();
        dir_information.access$002(result, new File(dirname).listFiles());
        result.index = -1;
        return result;
    }

    public static boolean read_directory_first(dir_information dirp, StringRef entry_name, BooleanRef is_directory) {
        if (dirp.list.length == 0) {
            return false;
        }
        entry_name.value = dirp.list[0].getName();
        is_directory.value = dirp.list[0].isDirectory();
        dirp.index = 0;
        return true;
    }

    public static boolean read_directory_next(dir_information dirp, StringRef entry_name, BooleanRef is_directory) {
        if (dirp.index + 1 >= dirp.list.length) {
            return false;
        }
        dirp.index++;
        entry_name.value = dirp.list[dirp.index].getName();
        is_directory.value = dirp.list[dirp.index].isDirectory();
        return true;
    }

    public static void close_directory(dir_information dirp) {
    }

    public static String ResolveHomedir(String temp_line) {
        return FileHelper.resolve_path(temp_line);
    }

    public static String CreatePlatformConfigDir() {
        String result = System.getProperty("user.dir");
        if (result != null && result.length() != 0 && new File(result).exists()) {
            File f = new File(result = result + File.separator + ".dosbox");
            if (!f.exists()) {
                f.mkdir();
            }
            return f.getAbsolutePath() + File.separator;
        }
        return "";
    }

    public static String GetPlatformConfigName() {
        return "dosbox-0.74.conf";
    }

    public static void CreateDir(String dir) {
        new File(dir).mkdirs();
    }

    public static class dir_information {
        private File[] list;
        private int index;

        static /* synthetic */ File[] access$002(dir_information x0, File[] x1) {
            x0.list = x1;
            return x1;
        }
    }
}

