/*
 * Decompiled with CFR 0.152.
 */
package jdos.misc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import jdos.Dosbox;
import jdos.misc.Log;
import jdos.misc.setup.Prop_path;
import jdos.misc.setup.Section_prop;

public class Msg {
    static Vector Lang = new Vector();

    public static void add(String name, String value) {
        for (int i = 0; i < Lang.size(); ++i) {
            MessageBlock m = (MessageBlock)Lang.elementAt(i);
            if (!m.name.equals(name)) continue;
            return;
        }
        Lang.add(new MessageBlock(name, value));
    }

    public static void replace(String name, String value) {
        for (int i = 0; i < Lang.size(); ++i) {
            MessageBlock m = (MessageBlock)Lang.elementAt(i);
            if (!m.name.equals(name)) continue;
            Lang.remove(m);
        }
        Lang.add(new MessageBlock(name, value));
    }

    public static void LoadMessageFile(String fname) {
        if (fname == null || fname.length() == 0) {
            return;
        }
        FileReader fr = null;
        try {
            fr = new FileReader(fname);
        }
        catch (FileNotFoundException e) {
            Log.exit("MSG:Can't load messages: " + fname);
        }
        BufferedReader br = new BufferedReader(fr);
        String name = "";
        String string = "";
        try {
            String linein;
            while ((linein = br.readLine()) != null) {
                if (linein.startsWith(":")) {
                    string = "";
                    name = linein.substring(1);
                    continue;
                }
                if (linein.startsWith(".")) {
                    if (string.endsWith("\n")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    Msg.replace(name, string);
                    continue;
                }
                string = string + linein + "\n";
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (fr != null) {
            try {
                fr.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static String get(String msg) {
        for (int i = 0; i < Lang.size(); ++i) {
            MessageBlock m = (MessageBlock)Lang.elementAt(i);
            if (!m.name.equals(msg)) continue;
            return m.val;
        }
        return "Message not Found!\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String location) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(location);
            for (int i = 0; i < Lang.size(); ++i) {
                MessageBlock m = (MessageBlock)Lang.elementAt(i);
                String line = ":" + m.name + "\n" + m.val + "\n.\n";
                fos.write(line.getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void init(Section_prop section) {
        String file_name = Dosbox.control.cmdline.FindString("-lang", true);
        if (file_name != null) {
            Msg.LoadMessageFile(file_name);
        } else {
            Prop_path pathprop = section.Get_path("language");
            if (pathprop != null) {
                Msg.LoadMessageFile(pathprop.realpath);
            }
        }
    }

    static class MessageBlock {
        String name;
        String val;

        public MessageBlock(String _name, String _val) {
            this.name = _name;
            this.val = _val;
        }
    }
}

