/*
 * Decompiled with CFR 0.152.
 */
package jdos.misc;

import java.util.Vector;
import jdos.Dosbox;
import jdos.cpu.Callback;
import jdos.dos.Dos;
import jdos.dos.Dos_PSP;
import jdos.dos.Dos_files;
import jdos.dos.drives.Drive_virtual;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.misc.Msg;
import jdos.misc.setup.CommandLine;
import jdos.misc.setup.Section;
import jdos.shell.Dos_shell;
import jdos.shell.Shell;
import jdos.util.FileIOFactory;
import jdos.util.IntRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public abstract class Program {
    private static int call_program;
    private static final byte[] exe_block;
    private static final int CB_POS = 12;
    private static Vector internal_progs;
    private static Callback.Handler PROGRAMS_Handler;
    protected String temp_line;
    protected CommandLine cmd;
    protected Dos_PSP psp = new Dos_PSP(Dos.dos.psp());
    private static PROGRAMS_Main CONFIG_ProgramStart;
    public static Section.SectionFunction PROGRAMS_Init;

    public abstract void Run();

    public static void PROGRAMS_MakeFile(String name, PROGRAMS_Main main) {
        byte[] comdata = new byte[32];
        System.arraycopy(exe_block, 0, comdata, 0, exe_block.length);
        comdata[12] = (byte)(call_program & 0xFF);
        comdata[13] = (byte)(call_program >> 8 & 0xFF);
        if (internal_progs.size() > 255) {
            Log.exit("PROGRAMS_MakeFile program size too large (" + internal_progs.size() + ")");
        }
        int index = internal_progs.size();
        internal_progs.addElement(main);
        comdata[Program.exe_block.length] = (byte)(index & 0xFF);
        int size = exe_block.length + 1;
        Drive_virtual.VFILE_Register(name, comdata, size);
    }

    public Program() {
        int envscan = Memory.PhysMake(this.psp.GetEnvironment(), 0);
        while (Memory.mem_readb(envscan) != 0) {
            envscan += Memory.mem_strlen(envscan) + 1;
        }
        envscan += 3;
        String tail = Memory.MEM_BlockRead(Memory.PhysMake(Dos.dos.psp(), 128), 128);
        if (tail.length() > 0) {
            tail = tail.substring(1, tail.charAt(0) + '\u0001');
        }
        String filename = Memory.MEM_StrCopy(envscan, 256);
        this.cmd = new CommandLine(filename, tail);
    }

    public void ChangeToLongCmd() {
        if (this.cmd.Get_arglength() > 100) {
            CommandLine temp;
            this.cmd = temp = new CommandLine(this.cmd.GetFileName(), Dos_shell.full_arguments);
        }
        Dos_shell.full_arguments = "";
    }

    protected void WriteOut(String format) {
        this.WriteOut(format, new Object[0]);
    }

    protected void WriteOut(String format, Object[] args) {
        String buf = StringHelper.sprintf(format, args);
        int size = buf.length();
        for (int i = 0; i < size; ++i) {
            byte[] out = new byte[1];
            IntRef s = new IntRef(1);
            if (buf.charAt(i) == '\n' && i > 0 && buf.charAt(i - 1) != '\r') {
                out[0] = 13;
                Dos_files.DOS_WriteFile(1, out, s);
            }
            out[0] = (byte)buf.charAt(i);
            Dos_files.DOS_WriteFile(1, out, s);
        }
    }

    protected void WriteOut_NoParsing(String format) {
        int size = format.length();
        for (int i = 0; i < size; ++i) {
            byte[] out = new byte[1];
            IntRef s = new IntRef(1);
            if (format.charAt(i) == '\n' && i > 0 && format.charAt(i - 1) != '\r') {
                out[0] = 13;
                Dos_files.DOS_WriteFile(1, out, s);
            }
            out[0] = (byte)format.charAt(i);
            Dos_files.DOS_WriteFile(1, out, s);
        }
    }

    public boolean GetEnvStr(String entry, StringRef result) {
        String key;
        String env_string;
        int pos;
        if (entry.equalsIgnoreCase("errorlevel")) {
            result.value = entry + "=" + String.valueOf(Dos.dos.return_code);
            return true;
        }
        int env_read = Memory.PhysMake(this.psp.GetEnvironment(), 0);
        result.value = "";
        if (entry.length() == 0) {
            return false;
        }
        do {
            if ((env_string = Memory.MEM_StrCopy(env_read, 1024)).length() == 0) {
                return false;
            }
            env_read += env_string.length() + 1;
        } while ((pos = env_string.indexOf(61)) < 0 || !(key = env_string.substring(0, pos)).equalsIgnoreCase(entry));
        result.value = env_string;
        return true;
    }

    public boolean GetEnvNum(int num, StringRef result) {
        int env_read = Memory.PhysMake(this.psp.GetEnvironment(), 0);
        String env_string;
        while ((env_string = Memory.MEM_StrCopy(env_read, 1024)).length() != 0) {
            if (num == 0) {
                result.value = env_string;
                return true;
            }
            env_read += env_string.length() + 1;
            --num;
        }
        return false;
    }

    public int GetEnvCount() {
        int env_read = Memory.PhysMake(this.psp.GetEnvironment(), 0);
        int num = 0;
        while (Memory.mem_readb(env_read) != 0) {
            while (Memory.mem_readb(env_read) != 0) {
                ++env_read;
            }
            ++env_read;
            ++num;
        }
        return num;
    }

    public boolean SetEnv(String entry, String new_string) {
        String env_string;
        int env_read;
        int env_write = env_read = Memory.PhysMake(this.psp.GetEnvironment(), 0);
        while ((env_string = Memory.MEM_StrCopy(env_read, 1024)).length() != 0) {
            String key;
            env_read += env_string.length() + 1;
            int pos = env_string.indexOf(61);
            if (pos < 0 || (key = env_string.substring(0, pos)).equalsIgnoreCase(entry)) continue;
            Memory.MEM_BlockWrite(env_write, env_string, env_string.length() + 1);
            env_write += env_string.length() + 1;
        }
        if (new_string.length() > 0) {
            new_string = entry.toUpperCase() + "=" + new_string;
            Memory.MEM_BlockWrite(env_write, new_string, new_string.length() + 1);
            env_write += new_string.length() + 1;
        }
        Memory.mem_writed(env_write, 0);
        return true;
    }

    static {
        exe_block = new byte[]{-68, 0, 4, -69, 64, 0, -76, 74, -51, 33, -2, 56, 0, 0, -72, 0, 76, -51, 33};
        internal_progs = new Vector();
        PROGRAMS_Handler = new Callback.Handler(){

            public String getName() {
                return "Program.PROGRAMS_Handler";
            }

            public int call() {
                short index;
                boolean size = true;
                int reader = Memory.PhysMake(Dos.dos.psp(), 256 + exe_block.length);
                if ((index = Memory.mem_readb(reader++)) > internal_progs.size()) {
                    Log.exit("something is messing with the memory");
                }
                PROGRAMS_Main handler2 = (PROGRAMS_Main)internal_progs.elementAt(index);
                Program new_program = handler2.call();
                new_program.Run();
                return 0;
            }
        };
        CONFIG_ProgramStart = new PROGRAMS_Main(){

            public Program call() {
                return new CONFIG();
            }
        };
        PROGRAMS_Init = new Section.SectionFunction(){

            public void call(Section section) {
                call_program = Callback.CALLBACK_Allocate();
                Callback.CALLBACK_Setup(call_program, PROGRAMS_Handler, 1, "internal program");
                Program.PROGRAMS_MakeFile("CONFIG.COM", CONFIG_ProgramStart);
                Msg.add("PROGRAM_CONFIG_FILE_ERROR", "Can't open file %s\n");
                Msg.add("PROGRAM_CONFIG_USAGE", "Config tool:\nUse -writeconf filename to write the current config.\nUse -writelang filename to write the current language strings.\n");
                Msg.add("PROGRAM_CONFIG_SECURE_ON", "Switched to secure mode.\n");
                Msg.add("PROGRAM_CONFIG_SECURE_DISALLOW", "This operation is not permitted in secure mode.\n");
                Msg.add("PROGRAM_CONFIG_SECTION_ERROR", "Section %s doesn't exist.\n");
                Msg.add("PROGRAM_CONFIG_PROPERTY_ERROR", "No such section or property.\n");
                Msg.add("PROGRAM_CONFIG_NO_PROPERTY", "There is no property %s in section %s.\n");
                Msg.add("PROGRAM_CONFIG_GET_SYNTAX", "Correct syntax: config -get \"section property\".\n");
            }
        };
    }

    static class CONFIG
    extends Program {
        CONFIG() {
        }

        public void Run() {
            Section sec;
            this.temp_line = this.cmd.FindString("-writeconf", true);
            if (this.temp_line != null || (this.temp_line = this.cmd.FindString("-wc", true)) != null) {
                if (Dosbox.control.SecureMode()) {
                    this.WriteOut(Msg.get("PROGRAM_CONFIG_SECURE_DISALLOW"));
                    return;
                }
                if (!FileIOFactory.canOpen(this.temp_line, 2)) {
                    this.WriteOut(Msg.get("PROGRAM_CONFIG_FILE_ERROR"), new Object[]{this.temp_line});
                    return;
                }
                Dosbox.control.PrintConfig(this.temp_line);
                return;
            }
            this.temp_line = this.cmd.FindString("-writelang", true);
            if (this.temp_line != null || (this.temp_line = this.cmd.FindString("-wl", true)) != null) {
                if (Dosbox.control.SecureMode()) {
                    this.WriteOut(Msg.get("PROGRAM_CONFIG_SECURE_DISALLOW"));
                    return;
                }
                if (!FileIOFactory.canOpen(this.temp_line, 2)) {
                    this.WriteOut(Msg.get("PROGRAM_CONFIG_FILE_ERROR"), new Object[]{this.temp_line});
                    return;
                }
                Msg.write(this.temp_line);
                return;
            }
            if (this.cmd.FindExist("-securemode", true)) {
                Dosbox.control.SwitchToSecureMode();
                this.WriteOut(Msg.get("PROGRAM_CONFIG_SECURE_ON"));
                return;
            }
            this.temp_line = this.cmd.FindString("-get", true);
            if (this.temp_line != null) {
                int space;
                String temp2 = this.cmd.GetStringRemain();
                if (temp2 != null && temp2.length() > 0) {
                    this.temp_line = this.temp_line + " " + temp2;
                }
                if ((space = this.temp_line.indexOf(" ")) < 0) {
                    this.WriteOut(Msg.get("PROGRAM_CONFIG_GET_SYNTAX"));
                    return;
                }
                String prop = this.temp_line.substring(space + 1);
                this.temp_line = this.temp_line.substring(0, space);
                Section sec2 = Dosbox.control.GetSection(this.temp_line);
                if (sec2 == null) {
                    this.WriteOut(Msg.get("PROGRAM_CONFIG_SECTION_ERROR"), new Object[]{this.temp_line});
                    return;
                }
                String val = sec2.GetPropValue(prop);
                if (val.equals("PROP_NOT_EXIST")) {
                    this.WriteOut(Msg.get("PROGRAM_CONFIG_NO_PROPERTY"), new Object[]{prop, this.temp_line});
                    return;
                }
                this.WriteOut(val);
                Shell.first_shell.SetEnv("CONFIG", val);
                return;
            }
            this.temp_line = this.cmd.FindString("-set", true);
            if (this.temp_line != null) {
                String temp2 = this.cmd.GetStringRemain();
                if (temp2 != null && temp2.length() > 0) {
                    this.temp_line = this.temp_line + " " + temp2;
                }
            } else {
                this.temp_line = this.cmd.GetStringRemain();
                if (this.temp_line == null) {
                    this.WriteOut(Msg.get("PROGRAM_CONFIG_USAGE"));
                    return;
                }
            }
            int pos = this.temp_line.indexOf(32);
            if (pos < 0) {
                pos = this.temp_line.indexOf(61);
            }
            if (pos < 0) {
                this.WriteOut(Msg.get("PROGRAM_CONFIG_USAGE"));
                return;
            }
            String copy = this.temp_line.substring(0, pos);
            this.temp_line = this.temp_line.substring(pos + 1);
            int sign = this.temp_line.indexOf(61);
            if (sign <= 0) {
                sign = this.temp_line.indexOf(32);
                if (sign >= 0) {
                    this.temp_line = this.temp_line.substring(0, sign) + "=" + this.temp_line.substring(sign + 1);
                } else {
                    sec = Dosbox.control.GetSectionFromProperty(copy);
                    if (sec == null) {
                        if (Dosbox.control.GetSectionFromProperty(this.temp_line) != null) {
                            return;
                        }
                        this.WriteOut(Msg.get("PROGRAM_CONFIG_PROPERTY_ERROR"), new Object[]{copy});
                        return;
                    }
                    this.temp_line = copy + "=" + this.temp_line;
                    copy = sec.GetName();
                    sign = this.temp_line.indexOf(32);
                    if (sign >= 0) {
                        this.temp_line = this.temp_line.substring(0, sign) + "=" + this.temp_line.substring(sign + 1);
                    }
                }
            }
            if ((sec = Dosbox.control.GetSection(copy)) == null) {
                this.WriteOut(Msg.get("PROGRAM_CONFIG_SECTION_ERROR"), new Object[]{copy});
                return;
            }
            sec.ExecuteDestroy(false);
            sec.HandleInputline(this.temp_line);
            sec.ExecuteInit(false);
        }
    }

    public static interface PROGRAMS_Main {
        public Program call();
    }
}

