/*
 * Decompiled with CFR 0.152.
 */
package jdos.misc.setup;

import java.util.Vector;

public class CommandLine {
    private Vector cmds;
    private String file_name;

    public CommandLine(String[] args) {
        this.cmds = new Vector(args.length);
        for (int i = 0; i < args.length; ++i) {
            this.cmds.add(args[i]);
        }
    }

    public CommandLine(String name, String cmdline) {
        this.cmds = new Vector();
        this.file_name = name;
        boolean inword = false;
        boolean inquote = false;
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < cmdline.length(); ++i) {
            char c = cmdline.charAt(i);
            if (inquote) {
                if (c != '\"') {
                    str.append(c);
                    continue;
                }
                inquote = false;
                this.cmds.addElement(str.toString());
                str = new StringBuffer();
                continue;
            }
            if (inword) {
                if (c != ' ') {
                    str.append(c);
                    continue;
                }
                inword = false;
                this.cmds.addElement(str.toString());
                str = new StringBuffer();
                continue;
            }
            if (c == '\"') {
                inquote = true;
                continue;
            }
            if (c == ' ') continue;
            str.append(c);
            inword = true;
        }
        if (inword || inquote) {
            this.cmds.addElement(str.toString());
        }
    }

    public String GetFileName() {
        return this.file_name;
    }

    public boolean FindExist(String name) {
        return this.FindExist(name, false);
    }

    public boolean FindExist(String name, boolean remove) {
        int index = this.FindEntry(name, false);
        if (index < 0) {
            return false;
        }
        if (remove) {
            this.cmds.removeElementAt(index);
        }
        return true;
    }

    public Integer FindHex(String name) {
        return this.FindHex(name, false);
    }

    public Integer FindHex(String name, boolean remove) {
        int index = this.FindEntry(name, true);
        if (index < 0) {
            return null;
        }
        try {
            Integer result = new Integer(Integer.parseInt((String)this.cmds.elementAt(index + 1), 16));
            if (remove) {
                this.cmds.removeElementAt(index);
                this.cmds.removeElementAt(index);
            }
            return result;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Integer FindInt(String name) {
        return this.FindInt(name, false);
    }

    public Integer FindInt(String name, boolean remove) {
        int index = this.FindEntry(name, true);
        if (index < 0) {
            return null;
        }
        try {
            Integer result = new Integer(Integer.parseInt((String)this.cmds.elementAt(index + 1), 10));
            if (remove) {
                this.cmds.removeElementAt(index);
                this.cmds.removeElementAt(index);
            }
            return result;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String FindString(String name) {
        return this.FindString(name, false);
    }

    public String FindString(String name, boolean remove) {
        int index = this.FindEntry(name, true);
        if (index < 0) {
            return null;
        }
        String result = (String)this.cmds.elementAt(index + 1);
        if (remove) {
            this.cmds.removeElementAt(index);
            this.cmds.removeElementAt(index);
        }
        return result;
    }

    public String FindCommand(int which) {
        if (which < 1) {
            return null;
        }
        if (which > this.cmds.size()) {
            return null;
        }
        return (String)this.cmds.elementAt(which - 1);
    }

    public String FindStringBegin(String begin) {
        return this.FindStringBegin(begin, false);
    }

    public String FindStringBegin(String begin, boolean remove) {
        begin = begin.toLowerCase();
        for (int i = 0; i < this.cmds.size(); ++i) {
            if (!((String)this.cmds.elementAt(i)).toLowerCase().startsWith(begin)) continue;
            String result = (String)this.cmds.elementAt(i);
            if (remove) {
                this.cmds.removeElementAt(i);
            }
            return result;
        }
        return null;
    }

    public String FindStringRemain(String name) {
        int index = this.FindEntry(name, false);
        if (index < 0) {
            return null;
        }
        StringBuffer value = new StringBuffer();
        for (int i = ++index; i < this.cmds.size(); ++i) {
            value.append(" ");
            value.append(this.cmds.elementAt(i));
        }
        return value.toString();
    }

    public String GetStringRemain() {
        if (this.cmds.size() == 0) {
            return null;
        }
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < this.cmds.size(); ++i) {
            if (i > 0) {
                value.append(" ");
            }
            value.append(this.cmds.elementAt(i));
        }
        return value.toString();
    }

    public void Shift() {
        this.Shift(1);
    }

    public void Shift(int amount) {
        for (int i = 0; i < amount; ++i) {
            String string = this.file_name = this.cmds.size() > 0 ? (String)this.cmds.elementAt(0) : "";
            if (this.cmds.size() <= 0) continue;
            this.cmds.removeElementAt(0);
        }
    }

    public int GetCount() {
        return this.cmds.size();
    }

    public int Get_arglength() {
        int result = 0;
        for (int i = 0; i < this.cmds.size(); ++i) {
            if (i > 0) {
                ++result;
            }
            result += ((String)this.cmds.elementAt(i)).length();
        }
        return result;
    }

    private int FindEntry(String name, boolean needNext) {
        for (int i = 0; i < this.cmds.size(); ++i) {
            if (!((String)this.cmds.elementAt(i)).equalsIgnoreCase(name)) continue;
            if (needNext && i == this.cmds.size() - 1) {
                return -1;
            }
            return i;
        }
        return -1;
    }
}

