/*
 * Decompiled with CFR 0.152.
 */
package jdos.misc.setup;

import java.util.Vector;
import jdos.misc.Log;
import jdos.misc.Msg;
import jdos.misc.setup.Value;

public abstract class Property {
    public final String propname;
    protected Value value = new Value();
    protected Vector suggested_values = new Vector();
    protected Value default_value = new Value();
    protected final int change;

    public Property(String _propname, int when) {
        this.propname = _propname;
        this.change = when;
    }

    public void Set_values(String[] in) {
        int type = this.default_value.type;
        for (int i = 0; i < in.length; ++i) {
            this.suggested_values.add(new Value(in[i], type));
        }
    }

    public void Set_help(String str) {
        String result = "CONFIG_" + this.propname;
        result = result.toUpperCase();
        Msg.add(result, str);
    }

    public String Get_help() {
        String result = "CONFIG_" + this.propname;
        result = result.toUpperCase();
        return Msg.get(result);
    }

    public abstract void SetValue(String var1);

    public Value GetValue() {
        return this.value;
    }

    public Value Get_Default_Value() {
        return this.default_value;
    }

    public boolean CheckValue(Value in, boolean warn) {
        if (this.suggested_values.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.suggested_values.size(); ++i) {
            Value v = (Value)this.suggested_values.elementAt(i);
            if (!in.equals(v)) continue;
            return true;
        }
        if (warn) {
            Log.log_msg("\"" + in.toString() + "\" is not a valid value for variable: " + this.propname + ".\nIt might now be reset to the default value: " + this.default_value.toString());
        }
        return false;
    }

    public void SetVal(Value in, boolean forced) {
        this.SetVal(in, forced, true);
    }

    public void SetVal(Value in, boolean forced, boolean warn) {
        this.value = forced || this.CheckValue(in, warn) ? in : this.default_value;
    }

    public Vector GetValues() {
        return this.suggested_values;
    }

    public int Get_type() {
        return this.default_value.type;
    }

    public static final class Changeable {
        public static final int Always = 0;
        public static final int WhenIdle = 1;
        public static final int OnlyAtStart = 2;
    }
}

