/*
 * Decompiled with CFR 0.152.
 */
package jdos.shell;

import java.util.Vector;
import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.dos.Dos;
import jdos.dos.Dos_DTA;
import jdos.dos.Dos_ParamBlock;
import jdos.dos.Dos_files;
import jdos.dos.Dos_memory;
import jdos.dos.drives.Drive_local;
import jdos.hardware.Memory;
import jdos.ints.Bios_keyboard;
import jdos.misc.Log;
import jdos.misc.Msg;
import jdos.misc.Program;
import jdos.misc.setup.CommandLine;
import jdos.misc.setup.Section;
import jdos.shell.BatchFile;
import jdos.shell.SHELL_Cmd;
import jdos.util.BooleanRef;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.ShortRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public class Dos_shell
extends Program {
    private Vector l_history = new Vector();
    private Vector l_completion = new Vector();
    int input_handle = 0;
    BatchFile bf = null;
    boolean echo = true;
    boolean exit = false;
    boolean call = false;
    String completion_start = null;
    int completion_index;
    public static String full_arguments;
    handler CMD_HELP = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "HELP")) {
                return;
            }
            boolean optall = Dos_shell.ScanCMDBool(args, "ALL");
            if (!optall) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_HELP"));
            }
            int cmd_index = 0;
            int write_count = 0;
            while (Dos_shell.this.cmd_list[cmd_index].name != null) {
                if (optall || Dos_shell.this.cmd_list[cmd_index].flags == 0) {
                    Dos_shell.this.WriteOut("<\u001b[34;1m" + StringHelper.leftJustify(Dos_shell.this.cmd_list[cmd_index].name, 8) + "\u001b[0m> " + Msg.get(Dos_shell.this.cmd_list[cmd_index].help));
                    if (++write_count % 22 == 0) {
                        Dos_shell.this.CMD_PAUSE.call("");
                    }
                }
                ++cmd_index;
            }
        }
    };
    handler CMD_CLS = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "CLS")) {
                return;
            }
            CPU_Regs.reg_eax.word(3);
            Callback.CALLBACK_RunRealInt(16);
        }
    };
    handler CMD_COPY = new handler(){

        public void call(String a) {
            String source_p;
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "COPY")) {
                return;
            }
            String defaulttarget = ".";
            args.value = Dos_shell.StripSpaces(args.value);
            int save_dta = Dos.dos.dta();
            Dos.dos.dta(Dos.dos.tables.tempdta);
            Dos_DTA dta = new Dos_DTA(Dos.dos.dta());
            LongRef size = new LongRef(0L);
            IntRef date = new IntRef(0);
            IntRef time = new IntRef(0);
            ShortRef attr = new ShortRef();
            StringRef name = new StringRef();
            Vector<copysource> sources = new Vector<copysource>();
            while (Dos_shell.ScanCMDBool(args, "B")) {
            }
            while (Dos_shell.ScanCMDBool(args, "T")) {
            }
            while (Dos_shell.ScanCMDBool(args, "A")) {
            }
            Dos_shell.ScanCMDBool(args, "Y");
            Dos_shell.ScanCMDBool(args, "-Y");
            String rem = Dos_shell.ScanCMDRemain(args);
            if (rem != null) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_SWITCH"), new Object[]{rem});
                Dos.dos.dta(save_dta);
                return;
            }
            while ((source_p = Dos_shell.StripWord(args)) != null && source_p.length() > 0) {
                int plus;
                do {
                    String source_x = (plus = source_p.indexOf(43)) >= 0 ? source_p.substring(0, plus) : source_p;
                    boolean has_drive_spec = false;
                    int source_x_len = source_x.length();
                    if (source_x_len > 0 && source_x.charAt(source_x_len - 1) == ':') {
                        has_drive_spec = true;
                    }
                    if (!has_drive_spec && Dos_files.DOS_FindFirst(source_x, 65527)) {
                        dta.GetResult(name, size, date, time, attr);
                        if ((attr.value & 0x10) != 0 && source_p.indexOf("*.*") < 0) {
                            source_x = source_x + "\\*.*";
                        }
                    }
                    sources.add(new copysource(source_x, plus >= 0));
                } while ((source_p = plus >= 0 ? source_p.substring(plus + 1) : "").length() > 0);
            }
            if (sources.size() == 0 || ((copysource)sources.elementAt((int)0)).filename.length() == 0) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_MISSING_PARAMETER"));
                Dos.dos.dta(save_dta);
                return;
            }
            copysource target = new copysource();
            if (sources.size() > 1 && !((copysource)sources.elementAt((int)(sources.size() - 2))).concat) {
                target = (copysource)sources.lastElement();
                sources.removeElementAt(sources.size() - 1);
            }
            if (target.filename.length() == 0) {
                target = new copysource(".", true);
            }
            copysource oldsource = new copysource();
            copysource source = new copysource();
            int count = 0;
            while (sources.size() > 0) {
                boolean ret;
                oldsource = source;
                source = (copysource)sources.firstElement();
                sources.remove(0);
                if (!oldsource.concat && source.concat && target.concat) {
                    target = source;
                    continue;
                }
                StringRef pathSource = new StringRef();
                StringRef pathTarget = new StringRef();
                if (!Dos_files.DOS_Canonicalize(source.filename, pathSource)) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_PATH"));
                    Dos.dos.dta(save_dta);
                    return;
                }
                int pos = pathSource.value.lastIndexOf(92);
                if (pos >= 0) {
                    pathSource.value = pathSource.value.substring(0, pos + 1);
                }
                if (!Dos_files.DOS_Canonicalize(target.filename, pathTarget)) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_PATH"));
                    Dos.dos.dta(save_dta);
                    return;
                }
                int temp = pathTarget.value.indexOf("*.*");
                if (temp >= 0) {
                    pathTarget.value = pathTarget.value.substring(0, temp);
                }
                if (pathTarget.value.charAt(pathTarget.value.length() - 1) != '\\' && Dos_files.DOS_FindFirst(pathTarget.value, 65527)) {
                    dta.GetResult(name, size, date, time, attr);
                    if ((attr.value & 0x10) != 0) {
                        pathTarget.value = pathTarget.value + "\\";
                    }
                }
                if (!(ret = Dos_files.DOS_FindFirst(source.filename, 65527))) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_FILE_NOT_FOUND"), new Object[]{source.filename});
                    Dos.dos.dta(save_dta);
                    return;
                }
                while (ret) {
                    dta.GetResult(name, size, date, time, attr);
                    if ((attr.value & 0x10) == 0) {
                        String nameSource = pathSource.value;
                        nameSource = nameSource + name.value;
                        IntRef sourceHandle = new IntRef(0);
                        IntRef targetHandle = new IntRef(0);
                        if (Dos_files.DOS_OpenFile(nameSource, 0, sourceHandle)) {
                            String nameTarget = pathTarget.value;
                            if (nameTarget.charAt(nameTarget.length() - 1) == '\\') {
                                nameTarget = nameTarget + name.value;
                            }
                            if (oldsource.concat || Dos_files.DOS_CreateFile(nameTarget, 0, targetHandle)) {
                                LongRef dummy = new LongRef(0L);
                                if (!oldsource.concat || Dos_files.DOS_OpenFile(nameTarget, 2, targetHandle) && Dos_files.DOS_SeekFile(targetHandle.value, dummy, 2)) {
                                    byte[] buffer = new byte[32768];
                                    boolean failed = false;
                                    IntRef toread = new IntRef(32768);
                                    do {
                                        failed |= Dos_files.DOS_ReadFile(sourceHandle.value, buffer, toread);
                                        failed |= Dos_files.DOS_WriteFile(targetHandle.value, buffer, toread);
                                    } while (toread.value == 32768);
                                    failed |= Dos_files.DOS_CloseFile(sourceHandle.value);
                                    failed |= Dos_files.DOS_CloseFile(targetHandle.value);
                                    Dos_shell.this.WriteOut(" " + name.value + "\n");
                                    if (!source.concat) {
                                        ++count;
                                    }
                                } else {
                                    Dos_files.DOS_CloseFile(sourceHandle.value);
                                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_COPY_FAILURE"), new Object[]{target.filename});
                                }
                            } else {
                                Dos_files.DOS_CloseFile(sourceHandle.value);
                                if (targetHandle.value != 0) {
                                    Dos_files.DOS_CloseFile(targetHandle.value);
                                }
                                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_COPY_FAILURE"), new Object[]{target.filename});
                            }
                        } else {
                            Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_COPY_FAILURE"), new Object[]{source.filename});
                        }
                    }
                    ret = Dos_files.DOS_FindNext();
                }
            }
            Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_COPY_SUCCESS"), new Object[]{new Integer(count)});
            Dos.dos.dta(save_dta);
        }
    };
    handler CMD_DIR = new handler(){

        public void call(String a) {
            StringRef path;
            IntRef attribute;
            int idx;
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "DIR")) {
                return;
            }
            StringRef line = new StringRef();
            if (Dos_shell.this.GetEnvStr("DIRCMD", line) && (idx = line.value.indexOf(61)) >= 0) {
                args.value = args.value + " " + line.value.substring(idx + 1);
            }
            boolean optW = Dos_shell.ScanCMDBool(args, "W");
            Dos_shell.ScanCMDBool(args, "S");
            boolean optP = Dos_shell.ScanCMDBool(args, "P");
            if (Dos_shell.ScanCMDBool(args, "WP") || Dos_shell.ScanCMDBool(args, "PW")) {
                optP = true;
                optW = true;
            }
            boolean optB = Dos_shell.ScanCMDBool(args, "B");
            boolean optAD = Dos_shell.ScanCMDBool(args, "AD");
            String rem = Dos_shell.ScanCMDRemain(args);
            if (rem != null) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_SWITCH"), new Object[]{rem});
                return;
            }
            int w_count = 0;
            int p_count = 0;
            int w_size = optW ? 5 : 1;
            long dir_count = 0L;
            long file_count = 0L;
            long byte_count = 0L;
            args.value = args.value.trim();
            if (args.value.length() == 0) {
                args.value = "*.*";
            } else if (args.value.endsWith("\\") || args.value.endsWith(":")) {
                args.value = args.value + "*.*";
            }
            args.value = Dos_shell.ExpandDot(args);
            if (args.value.indexOf("*") < 0 && args.value.indexOf("?") < 0 && Dos_files.DOS_GetFileAttr(args.value, attribute = new IntRef(0)) && (attribute.value & 0x10) != 0) {
                args.value = args.value + "\\*.*";
            }
            if (args.value.indexOf(46) < 0) {
                args.value = args.value + ".*";
            }
            if (!Dos_files.DOS_Canonicalize(args.value, path = new StringRef())) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_PATH"));
                return;
            }
            path.value = path.value.substring(0, path.value.lastIndexOf(92) + 1);
            if (!optB) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_DIR_INTRO"), new Object[]{path.value});
            }
            int save_dta = Dos.dos.dta();
            Dos.dos.dta(Dos.dos.tables.tempdta);
            Dos_DTA dta = new Dos_DTA(Dos.dos.dta());
            boolean ret = Dos_files.DOS_FindFirst(args.value, 65527);
            if (!ret) {
                if (!optB) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_FILE_NOT_FOUND"), new Object[]{args.value});
                }
                Dos.dos.dta(save_dta);
                return;
            }
            do {
                StringRef name = new StringRef();
                LongRef size = new LongRef(0L);
                IntRef date = new IntRef(0);
                IntRef time = new IntRef(0);
                ShortRef attr = new ShortRef(0);
                dta.GetResult(name, size, date, time, attr);
                if (optAD && (attr.value & 0x10) == 0) continue;
                if (optB) {
                    if (!name.equals(".") && !name.equals("..")) {
                        Dos_shell.this.WriteOut(name + "\n");
                    }
                } else {
                    int pos;
                    String ext = "";
                    if (!optW && !name.value.startsWith(".") && (pos = name.value.lastIndexOf(46)) >= 0) {
                        ext = name.value.substring(pos + 1);
                        name.value = name.value.substring(0, pos);
                    }
                    short day = (short)(date.value & 0x1F);
                    short month = (short)(date.value >> 5 & 0xF);
                    int year = (date.value >> 9) + 1980;
                    short hour = (short)(time.value >> 5 >> 6);
                    short minute = (short)(time.value >> 5 & 0x3F);
                    if ((attr.value & 0x10) != 0) {
                        if (optW) {
                            Dos_shell.this.WriteOut("[" + name.value + "]");
                            int namelen = name.value.length();
                            if (namelen <= 14) {
                                for (int i = 14 - namelen; i > 0; --i) {
                                    Dos_shell.this.WriteOut(" ");
                                }
                            }
                        } else {
                            Dos_shell.this.WriteOut("%-8s %-3s   %-16s %02d-%02d-%04d %2d:%02d\n", new Object[]{name.value, ext, "<DIR>", new Integer(day), new Integer(month), new Integer(year), new Integer(hour), new Integer(minute)});
                        }
                        ++dir_count;
                    } else {
                        if (optW) {
                            Dos_shell.this.WriteOut("%-16s", new Object[]{name.value});
                        } else {
                            String numformat = Dos_shell.FormatNumber(size.value);
                            Dos_shell.this.WriteOut("%-8s %-3s   %16s %02d-%02d-%04d %2d:%02d\n", new Object[]{name.value, ext, numformat, new Integer(day), new Integer(month), new Integer(year), new Integer(hour), new Integer(minute)});
                        }
                        ++file_count;
                        byte_count += size.value;
                    }
                    if (optW) {
                        ++w_count;
                    }
                }
                if (!optP || ++p_count % (22 * w_size) != 0) continue;
                Dos_shell.this.CMD_PAUSE.call("");
            } while (ret = Dos_files.DOS_FindNext());
            if (optW && w_count % 5 != 0) {
                Dos_shell.this.WriteOut("\n");
            }
            if (!optB) {
                String numformat = Dos_shell.FormatNumber(byte_count);
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_DIR_BYTES_USED"), new Object[]{new Long(file_count), numformat});
                short drive = dta.GetSearchDrive();
                int free_space = 0x6400000;
                if (Dos_files.Drives[drive] != null) {
                    IntRef bytes_sector = new IntRef(0);
                    ShortRef sectors_cluster = new ShortRef();
                    IntRef total_clusters = new IntRef(0);
                    IntRef free_clusters = new IntRef(0);
                    Dos_files.Drives[drive].AllocationInfo(bytes_sector, sectors_cluster, total_clusters, free_clusters);
                    free_space = bytes_sector.value * sectors_cluster.value * free_clusters.value;
                }
                numformat = Dos_shell.FormatNumber(free_space);
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_DIR_BYTES_FREE"), new Object[]{new Long(dir_count), numformat});
            }
            Dos.dos.dta(save_dta);
        }
    };
    handler CMD_DELETE = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "DELETE")) {
                return;
            }
            int save_dta = Dos.dos.dta();
            Dos.dos.dta(Dos.dos.tables.tempdta);
            String rem = Dos_shell.ScanCMDRemain(args);
            if (rem != null) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_SWITCH"), new Object[]{rem});
                return;
            }
            StringRef full = new StringRef();
            args.value = Dos_shell.ExpandDot(args);
            args.value = Dos_shell.StripSpaces(args.value);
            if (!Dos_files.DOS_Canonicalize(args.value, full)) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_PATH"));
                return;
            }
            boolean res = Dos_files.DOS_FindFirst(args.value, 65527);
            if (!res) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_DEL_ERROR"), new Object[]{args});
                Dos.dos.dta(save_dta);
                return;
            }
            String path = full.value.substring(0, full.value.lastIndexOf("\\"));
            StringRef name = new StringRef();
            LongRef size = new LongRef(0L);
            IntRef time = new IntRef(0);
            IntRef date = new IntRef(0);
            ShortRef attr = new ShortRef(0);
            Dos_DTA dta = new Dos_DTA(Dos.dos.dta());
            while (res) {
                dta.GetResult(name, size, date, time, attr);
                if ((attr.value & 0x11) == 0 && !Dos_files.DOS_UnlinkFile(path + name.value)) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_DEL_ERROR"), new Object[]{full.value});
                }
                res = Dos_files.DOS_FindNext();
            }
            Dos.dos.dta(save_dta);
        }
    };
    handler CMD_ECHO = new handler(){

        public void call(String args) {
            if (args.length() == 0) {
                if (Dos_shell.this.echo) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_ECHO_ON"));
                } else {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_ECHO_OFF"));
                }
                return;
            }
            String cmd = Dos_shell.StripSpaces(args);
            if (cmd.equalsIgnoreCase("OFF")) {
                Dos_shell.this.echo = false;
                return;
            }
            if (cmd.equalsIgnoreCase("ON")) {
                Dos_shell.this.echo = true;
                return;
            }
            StringRef a = new StringRef(cmd);
            if (cmd.equalsIgnoreCase("/?") && Dos_shell.this.HELP(a, "ECHO")) {
                return;
            }
            if ((args = args.substring(1)).endsWith("\r")) {
                Log.log(21, 1, "Hu ? carriage return allready present. Is this possible?");
                Dos_shell.this.WriteOut(args + "\n");
            } else {
                Dos_shell.this.WriteOut(args + "\r\n");
            }
        }
    };
    handler CMD_EXIT = new handler(){

        public void call(String args) {
            StringRef a = new StringRef(args);
            if (Dos_shell.this.HELP(a, "EXIT")) {
                return;
            }
            Dos_shell.this.exit = true;
        }
    };
    handler CMD_MKDIR = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "MKDIR")) {
                return;
            }
            args.value = Dos_shell.StripSpaces(args.value);
            String rem = Dos_shell.ScanCMDRemain(args);
            if (rem != null) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_SWITCH"), new Object[]{rem});
                return;
            }
            if (!Dos_files.DOS_MakeDir(args.value)) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_MKDIR_ERROR"), new Object[]{args});
            }
        }
    };
    handler CMD_CHDIR = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "CHDIR")) {
                return;
            }
            args.value = Dos_shell.StripSpaces(args.value);
            if (args.value.length() == 0) {
                char drive = (char)(Dos_files.DOS_GetDefaultDrive() + 65);
                StringRef dir = new StringRef();
                Dos_files.DOS_GetCurrentDir((short)0, dir);
                Dos_shell.this.WriteOut(String.valueOf(drive) + ":\\" + dir + "\n");
            } else if (args.value.length() == 2 && args.value.charAt(1) == ':') {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_CHDIR_HINT"), new Object[]{args.value.toUpperCase()});
            } else if (!Dos_files.DOS_ChangeDir(args.value)) {
                String temps = args.value.toUpperCase();
                temps = StringHelper.replace(temps, "/", "\\");
                String[] slash = StringHelper.split(temps, "\\");
                StringBuffer shortversion = new StringBuffer();
                boolean space = false;
                boolean toolong = false;
                for (int i = 0; i < slash.length; ++i) {
                    if (slash[i].indexOf(32) >= 0) {
                        space = true;
                    }
                    if (slash[i].length() > 8) {
                        toolong = true;
                    }
                    String s = slash[i];
                    s = StringHelper.replace(s, " ", "");
                    s = StringHelper.replace(s, ".", "");
                    if ((s = StringHelper.replace(s, "\"", "")).length() > 6) {
                        s = s.substring(0, 6) + "~1";
                    }
                    if (i > 0) {
                        shortversion.append("\\");
                    }
                    shortversion.append(s);
                }
                if (space) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_CHDIR_HINT_2"), new Object[]{shortversion.toString()});
                } else if (toolong) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_CHDIR_HINT_2"), new Object[]{shortversion.toString()});
                } else {
                    char drive = (char)(Dos_files.DOS_GetDefaultDrive() + 65);
                    if (drive == 'Z') {
                        Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_CHDIR_HINT_3"));
                    } else {
                        Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_CHDIR_ERROR"), new Object[]{args.value});
                    }
                }
            }
        }
    };
    handler CMD_RMDIR = new handler(){

        public void call(String ar) {
            StringRef args = new StringRef(ar);
            if (Dos_shell.this.HELP(args, "RMDIR")) {
                return;
            }
            args.value = Dos_shell.StripSpaces(args.value);
            String rem = Dos_shell.ScanCMDRemain(args);
            if (rem != null) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_SWITCH"), new Object[]{rem});
                return;
            }
            if (!Dos_files.DOS_RemoveDir(args.value)) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_RMDIR_ERROR"), new Object[]{args});
            }
        }
    };
    handler CMD_SET = new handler(){

        public void call(String ar) {
            StringRef args = new StringRef(ar);
            if (Dos_shell.this.HELP(args, "SET")) {
                return;
            }
            args.value = Dos_shell.StripSpaces(args.value);
            StringRef line = new StringRef();
            if (args.value.length() == 0) {
                int count = Dos_shell.this.GetEnvCount();
                for (int a = 0; a < count; ++a) {
                    if (!Dos_shell.this.GetEnvNum(a, line)) continue;
                    Dos_shell.this.WriteOut(line.value + "\n");
                }
                return;
            }
            int p = args.value.indexOf("=");
            if (p < 0) {
                if (!Dos_shell.this.GetEnvStr(args.value, line)) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_SET_NOT_SET"), new Object[]{args.value});
                }
                Dos_shell.this.WriteOut(line.value + "\n");
            } else {
                String key = args.value.substring(0, p);
                ++p;
                StringBuffer parsed = new StringBuffer();
                while (p < args.value.length()) {
                    char c = args.value.charAt(p);
                    if (c != '%') {
                        parsed.append(c);
                        ++p;
                        continue;
                    }
                    if (p + 1 < args.value.length() && args.value.charAt(p + 1) == '%') {
                        parsed.append('%');
                        p += 2;
                        continue;
                    }
                    int second = args.value.indexOf(37, p + 1);
                    if (second < 0) continue;
                    StringRef temp = new StringRef();
                    if (Dos_shell.this.GetEnvStr(args.value.substring(p + 1, second), temp)) {
                        int pos = temp.value.indexOf(61);
                        if (pos < 0) continue;
                        parsed.append(temp.value.substring(pos + 1));
                    }
                    p = second + 1;
                }
                if (!Dos_shell.this.SetEnv(key, parsed.toString())) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_SET_OUT_OF_SPACE"));
                }
            }
        }
    };
    handler CMD_IF = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "IF")) {
                return;
            }
            args.value = Dos_shell.StripSpaces(args.value, '=');
            boolean has_not = false;
            while (args.value.toUpperCase().startsWith("NOT") && args.value.length() > 3 && (StringHelper.isspace(args.value.charAt(3)) || args.value.charAt(3) == '=')) {
                args.value = args.value.substring(3);
                args.value = Dos_shell.StripSpaces(args.value, '=');
                has_not = !has_not;
            }
            if (args.value.toUpperCase().startsWith("ERRORLEVEL")) {
                args.value = args.value.substring(10);
                args.value = Dos_shell.StripSpaces(args.value, '=');
                String word = Dos_shell.StripWord(args);
                if (!StringHelper.isdigit(word.charAt(0))) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_IF_ERRORLEVEL_MISSING_NUMBER"));
                    return;
                }
                short n = 0;
                do {
                    n = n * 10 + (word.charAt(0) - 48);
                } while ((word = word.substring(1)).length() > 0 && StringHelper.isdigit(word.charAt(0)));
                if (word.length() > 0 && !StringHelper.isspace(word.charAt(0))) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_IF_ERRORLEVEL_INVALID_NUMBER"));
                    return;
                }
                if (Dos.dos.return_code >= n == !has_not) {
                    Dos_shell.this.DoCommand(args.value);
                }
                return;
            }
            if (args.value.toUpperCase().startsWith("EXIST ")) {
                args.value = args.value.substring(6);
                args.value = Dos_shell.StripSpaces(args.value);
                String word = Dos_shell.StripWord(args);
                if (word.length() == 0) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_IF_EXIST_MISSING_FILENAME"));
                    return;
                }
                int save_dta = Dos.dos.dta();
                Dos.dos.dta(Dos.dos.tables.tempdta);
                boolean ret = Dos_files.DOS_FindFirst(word, 65527);
                Dos.dos.dta(save_dta);
                if (ret == !has_not) {
                    Dos_shell.this.DoCommand(args.value);
                }
                return;
            }
            String word = "";
            while (args.value.length() > 0 && !StringHelper.isspace(args.value.charAt(0)) && args.value.charAt(0) != '=') {
                word = word + args.value.substring(0, 1);
                args.value = args.value.substring(1);
            }
            while (args.value.length() > 0 && args.value.charAt(0) != '=') {
                args.value = args.value.substring(1);
            }
            if (args.value.length() < 2 || args.value.charAt(1) != '=') {
                Dos_shell.this.SyntaxError();
                return;
            }
            args.value = args.value.substring(2);
            args.value = Dos_shell.StripSpaces(args.value, '=');
            String word2 = "";
            while (args.value.length() > 0 && !StringHelper.isspace(args.value.charAt(0)) && args.value.charAt(0) != '=') {
                word2 = word2 + args.value.substring(0, 1);
                args.value = args.value.substring(1);
            }
            if (args.value.length() > 0) {
                args.value = Dos_shell.StripSpaces(args.value, '=');
                if (word.equals(word2) == !has_not) {
                    Dos_shell.this.DoCommand(args.value);
                }
            }
        }
    };
    handler CMD_GOTO = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "GOTO")) {
                return;
            }
            args.value = Dos_shell.StripSpaces(args.value);
            if (Dos_shell.this.bf == null) {
                return;
            }
            if (args.value.length() > 0 && args.value.charAt(0) == ':') {
                args.value = args.value.substring(1);
            }
            for (int i = 0; i < args.value.length(); ++i) {
                if (args.value.charAt(0) != ' ' && args.value.charAt(0) != '\t') continue;
                args.value = args.value.substring(0, i);
                break;
            }
            if (args.value.length() == 0) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_GOTO_MISSING_LABEL"));
                return;
            }
            if (!Dos_shell.this.bf.Goto(args.value)) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_GOTO_LABEL_NOT_FOUND"), new Object[]{args});
                return;
            }
        }
    };
    handler CMD_TYPE = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "TYPE")) {
                return;
            }
            args.value = Dos_shell.StripSpaces(args.value);
            if (args.value.length() == 0) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_SYNTAXERROR"));
                return;
            }
            IntRef handle = new IntRef(0);
            do {
                String word;
                if (!Dos_files.DOS_OpenFile(word = Dos_shell.StripWord(args), 0, handle)) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_FILE_NOT_FOUND"), new Object[]{word});
                    return;
                }
                IntRef n = new IntRef(0);
                byte[] c = new byte[1];
                do {
                    n.value = 1;
                    Dos_files.DOS_ReadFile(handle.value, c, n);
                    Dos_files.DOS_WriteFile(1, c, n);
                } while (n.value > 0);
                Dos_files.DOS_CloseFile(handle.value);
            } while (args.value.length() != 0);
        }
    };
    handler CMD_REM = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            Dos_shell.this.HELP(args, "REM");
        }
    };
    handler CMD_RENAME = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "RENAME")) {
                return;
            }
            args.value = Dos_shell.StripSpaces(args.value);
            if (args.value.length() == 0) {
                Dos_shell.this.SyntaxError();
                return;
            }
            if (args.value.indexOf(42) >= 0 || args.value.indexOf(63) >= 0) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_NO_WILD"));
                return;
            }
            String arg1 = Dos_shell.StripWord(args);
            int slash = arg1.lastIndexOf(92);
            if (slash >= 0) {
                String dir_source = arg1.substring(0, slash);
                ++slash;
                if (dir_source.length() == 2 && dir_source.charAt(1) == ':') {
                    dir_source = dir_source + "\\";
                }
                StringRef dir_current = new StringRef();
                Dos_files.DOS_GetCurrentDir((short)0, dir_current);
                if (!Dos_files.DOS_ChangeDir(dir_source)) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_PATH"));
                    return;
                }
                Dos_files.DOS_Rename(arg1.substring(slash), args.value);
                Dos_files.DOS_ChangeDir(dir_current.value);
            } else {
                Dos_files.DOS_Rename(arg1, args.value);
            }
        }
    };
    handler CMD_CALL = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "CALL")) {
                return;
            }
            Dos_shell.this.call = true;
            Dos_shell.this.ParseLine(args.value);
            Dos_shell.this.call = false;
        }
    };
    handler CMD_PAUSE = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "PAUSE")) {
                return;
            }
            Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_PAUSE"));
            byte[] c = new byte[1];
            IntRef n = new IntRef(1);
            Dos_files.DOS_ReadFile(0, c, n);
        }
    };
    handler CMD_SUBST = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "SUBST")) {
                return;
            }
            String mountstring = "MOUNT ";
            args.value = Dos_shell.StripSpaces(args.value);
            CommandLine command = new CommandLine(null, args.value);
            if (command.GetCount() != 2) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_SUBST_FAILURE"));
                return;
            }
            String arg = command.FindCommand(1);
            if (arg.length() > 1 && arg.charAt(1) != ':') {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_SUBST_FAILURE"));
                return;
            }
            arg = command.FindCommand(2);
            String temp_str = args.value.substring(0, 1).toUpperCase();
            if (arg.toUpperCase().equals("/D")) {
                if (Dos_files.Drives[temp_str.charAt(0) - 65] == null) {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_SUBST_NO_REMOVE"));
                    return;
                }
                mountstring = mountstring + "-u ";
                mountstring = mountstring + temp_str;
                Dos_shell.this.ParseLine(mountstring);
                return;
            }
            if (Dos_files.Drives[temp_str.charAt(0) - 65] != null) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_SUBST_FAILURE"));
                return;
            }
            mountstring = mountstring + temp_str;
            mountstring = mountstring + " ";
            StringRef fulldir = new StringRef();
            ShortRef drive = new ShortRef(0);
            if (!Dos_files.DOS_MakeName(arg, fulldir, drive)) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_SUBST_FAILURE"));
                return;
            }
            if (!(Dos_files.Drives[drive.value] instanceof Drive_local)) {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_SUBST_FAILURE"));
                return;
            }
            Drive_local ldp = (Drive_local)Dos_files.Drives[drive.value];
            StringRef newname = new StringRef(ldp.basedir);
            newname.value = newname.value + fulldir.value;
            ldp.dirCache.ExpandName(newname);
            mountstring = mountstring + "\"";
            mountstring = mountstring + newname.value;
            mountstring = mountstring + "\"";
            Dos_shell.this.ParseLine(mountstring);
        }
    };
    handler CMD_LOADHIGH = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "LOADHIGH")) {
                return;
            }
            int umb_start = Dos.dos_infoblock.GetStartOfUMBChain();
            short umb_flag = Dos.dos_infoblock.GetUMBChainState();
            short old_memstrat = (short)(Dos_memory.DOS_GetMemAllocStrategy() & 0xFF);
            if (umb_start == 40959) {
                if ((umb_flag & 1) == 0) {
                    Dos_memory.DOS_LinkUMBsToMemChain(1);
                }
                Dos_memory.DOS_SetMemAllocStrategy(128);
                Dos_shell.this.ParseLine(args.value);
                short current_umb_flag = Dos.dos_infoblock.GetUMBChainState();
                if ((current_umb_flag & 1) != (umb_flag & 1)) {
                    Dos_memory.DOS_LinkUMBsToMemChain(umb_flag);
                }
                Dos_memory.DOS_SetMemAllocStrategy(old_memstrat);
            } else {
                Dos_shell.this.ParseLine(args.value);
            }
        }
    };
    handler CMD_CHOICE = new handler(){

        public void call(String a) {
            int pos;
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "CHOICE")) {
                return;
            }
            String defchoice = "yn";
            String rem = null;
            boolean optN = Dos_shell.ScanCMDBool(args, "N");
            boolean optS = Dos_shell.ScanCMDBool(args, "S");
            boolean timeout = false;
            String timeoutChoice = "";
            int timeoutTime = -1;
            if (args.value.indexOf("/T") >= 0) {
                int pos3;
                int pos1 = args.value.indexOf("/T");
                int pos2 = args.value.indexOf(" ", pos1);
                String command = args.value.substring(pos1 + 2, pos2);
                args.value = args.value.substring(0, pos1) + args.value.substring(pos2 + 1);
                if (command.startsWith(":")) {
                    command = command.substring(1);
                }
                if ((pos3 = command.indexOf(",")) >= 0) {
                    timeoutChoice = command.substring(0, pos3);
                    try {
                        timeoutTime = Integer.parseInt(command.substring(pos3 + 1));
                        timeout = true;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (args.value.length() > 0) {
                args.value = Dos_shell.StripSpaces(args.value);
                rem = Dos_shell.ScanCMDRemain(args);
                if (rem != null && rem.toLowerCase().charAt(0) != 'c') {
                    Dos_shell.this.WriteOut(Msg.get("SHELL_ILLEGAL_SWITCH"), new Object[]{rem});
                    return;
                }
                if (rem != null && args.value.substring(1).startsWith(rem)) {
                    args.value = args.value.substring(rem.length() + 1);
                }
                if (rem != null) {
                    rem = rem.substring(2);
                }
                if (rem != null && rem.charAt(0) == ':') {
                    rem = rem.substring(1);
                }
            }
            if (rem == null || rem.length() == 0) {
                rem = "yn";
            }
            if (!optS) {
                rem = rem.toUpperCase();
            }
            if (args.value.length() > 0) {
                args.value = Dos_shell.StripSpaces(args.value);
                int argslen = args.value.length();
                if (argslen > 1 && args.value.charAt(0) == '\"' && args.value.charAt(argslen - 1) == '\"') {
                    args.value = args.value.substring(1, argslen - 1);
                }
                Dos_shell.this.WriteOut(args.value);
            }
            if (!optN) {
                if (args.value.length() > 0) {
                    Dos_shell.this.WriteOut(" ");
                }
                Dos_shell.this.WriteOut("[");
                int len = rem.length();
                for (int t = 1; t < len; ++t) {
                    Dos_shell.this.WriteOut(String.valueOf(rem.charAt(t - 1)) + ",");
                }
                Dos_shell.this.WriteOut(String.valueOf(rem.charAt(len - 1)) + "]?");
            }
            IntRef n = new IntRef(1);
            byte[] c = new byte[1];
            do {
                DefaultChoice defaultChoice = null;
                if (timeout) {
                    defaultChoice = new DefaultChoice();
                    defaultChoice.choice = timeoutChoice.getBytes();
                    defaultChoice.timeout = timeoutTime;
                    defaultChoice.start();
                }
                Dos_files.DOS_ReadFile(0, c, n);
                if (defaultChoice == null) continue;
                defaultChoice.interrupt();
                try {
                    defaultChoice.join(1000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            } while ((pos = optS ? rem.indexOf((char)c[0]) : rem.indexOf(new String(c).toUpperCase())) < 0);
            c = optS ? c : new String(c).toUpperCase().getBytes();
            Dos_files.DOS_WriteFile(1, c, n);
            Dos.dos.return_code = (short)(pos + 1);
        }
    };
    handler CMD_ATTRIB = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "ATTRIB")) {
                return;
            }
        }
    };
    handler CMD_PATH = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "PATH")) {
                return;
            }
            if (args.value.length() > 0) {
                String pathstring = "set PATH=";
                while (args.value.length() > 0 && (args.value.charAt(0) == '=' || args.value.charAt(0) == ' ')) {
                    args.value = args.value.substring(1);
                }
                pathstring = pathstring + args.value;
                Dos_shell.this.ParseLine(pathstring);
                return;
            }
            StringRef line = new StringRef();
            if (Dos_shell.this.GetEnvStr("PATH", line)) {
                Dos_shell.this.WriteOut(line.value);
            } else {
                Dos_shell.this.WriteOut("PATH=(null)");
            }
        }
    };
    handler CMD_SHIFT = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "SHIFT")) {
                return;
            }
            if (Dos_shell.this.bf != null) {
                Dos_shell.this.bf.Shift();
            }
        }
    };
    handler CMD_VER = new handler(){

        public void call(String a) {
            StringRef args = new StringRef(a);
            if (Dos_shell.this.HELP(args, "VER")) {
                return;
            }
            if (args.value.length() > 0) {
                String word = Dos_shell.StripWord(args);
                if (!word.equalsIgnoreCase("set")) {
                    return;
                }
                word = Dos_shell.StripWord(args);
                try {
                    Dos.dos.version.major = (byte)Integer.parseInt(word);
                    Dos.dos.version.minor = (byte)Integer.parseInt(args.value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Dos_shell.this.WriteOut(Msg.get("SHELL_CMD_VER_VER"), new Object[]{"0.74.25b", new Integer(Dos.dos.version.major), new Integer(Dos.dos.version.minor)});
            }
        }
    };
    SHELL_Cmd[] cmd_list = new SHELL_Cmd[]{new SHELL_Cmd("DIR", 0, this.CMD_DIR, "SHELL_CMD_DIR_HELP"), new SHELL_Cmd("CHDIR", 1, this.CMD_CHDIR, "SHELL_CMD_CHDIR_HELP"), new SHELL_Cmd("ATTRIB", 1, this.CMD_ATTRIB, "SHELL_CMD_ATTRIB_HELP"), new SHELL_Cmd("CALL", 1, this.CMD_CALL, "SHELL_CMD_CALL_HELP"), new SHELL_Cmd("CD", 0, this.CMD_CHDIR, "SHELL_CMD_CHDIR_HELP"), new SHELL_Cmd("CHOICE", 1, this.CMD_CHOICE, "SHELL_CMD_CHOICE_HELP"), new SHELL_Cmd("CLS", 0, this.CMD_CLS, "SHELL_CMD_CLS_HELP"), new SHELL_Cmd("COPY", 0, this.CMD_COPY, "SHELL_CMD_COPY_HELP"), new SHELL_Cmd("DEL", 0, this.CMD_DELETE, "SHELL_CMD_DELETE_HELP"), new SHELL_Cmd("DELETE", 1, this.CMD_DELETE, "SHELL_CMD_DELETE_HELP"), new SHELL_Cmd("ERASE", 1, this.CMD_DELETE, "SHELL_CMD_DELETE_HELP"), new SHELL_Cmd("ECHO", 1, this.CMD_ECHO, "SHELL_CMD_ECHO_HELP"), new SHELL_Cmd("EXIT", 0, this.CMD_EXIT, "SHELL_CMD_EXIT_HELP"), new SHELL_Cmd("GOTO", 1, this.CMD_GOTO, "SHELL_CMD_GOTO_HELP"), new SHELL_Cmd("HELP", 1, this.CMD_HELP, "SHELL_CMD_HELP_HELP"), new SHELL_Cmd("IF", 1, this.CMD_IF, "SHELL_CMD_IF_HELP"), new SHELL_Cmd("LOADHIGH", 1, this.CMD_LOADHIGH, "SHELL_CMD_LOADHIGH_HELP"), new SHELL_Cmd("LH", 1, this.CMD_LOADHIGH, "SHELL_CMD_LOADHIGH_HELP"), new SHELL_Cmd("MKDIR", 1, this.CMD_MKDIR, "SHELL_CMD_MKDIR_HELP"), new SHELL_Cmd("MD", 0, this.CMD_MKDIR, "SHELL_CMD_MKDIR_HELP"), new SHELL_Cmd("PATH", 1, this.CMD_PATH, "SHELL_CMD_PATH_HELP"), new SHELL_Cmd("PAUSE", 1, this.CMD_PAUSE, "SHELL_CMD_PAUSE_HELP"), new SHELL_Cmd("RMDIR", 1, this.CMD_RMDIR, "SHELL_CMD_RMDIR_HELP"), new SHELL_Cmd("RD", 0, this.CMD_RMDIR, "SHELL_CMD_RMDIR_HELP"), new SHELL_Cmd("REM", 1, this.CMD_REM, "SHELL_CMD_REM_HELP"), new SHELL_Cmd("RENAME", 1, this.CMD_RENAME, "SHELL_CMD_RENAME_HELP"), new SHELL_Cmd("REN", 0, this.CMD_RENAME, "SHELL_CMD_RENAME_HELP"), new SHELL_Cmd("SET", 1, this.CMD_SET, "SHELL_CMD_SET_HELP"), new SHELL_Cmd("SHIFT", 1, this.CMD_SHIFT, "SHELL_CMD_SHIFT_HELP"), new SHELL_Cmd("SUBST", 1, this.CMD_SUBST, "SHELL_CMD_SUBST_HELP"), new SHELL_Cmd("TYPE", 0, this.CMD_TYPE, "SHELL_CMD_TYPE_HELP"), new SHELL_Cmd("VER", 0, this.CMD_VER, "SHELL_CMD_VER_HELP"), new SHELL_Cmd(null, 0, null, null)};

    public void Run() {
        String line = this.cmd.FindStringRemain("/C");
        if (line != null) {
            int pos = line.indexOf(10);
            if (pos >= 0) {
                line = line.substring(0, pos);
            }
            if ((pos = line.indexOf(13)) >= 0) {
                line = line.substring(0, pos);
            }
            Dos_shell temp = new Dos_shell();
            temp.echo = this.echo;
            temp.ParseLine(line);
            temp.RunInternal();
            return;
        }
        this.WriteOut(Msg.get("SHELL_STARTUP_BEGIN"), new Object[]{"0.74.25b"});
        if (Dosbox.machine == 1) {
            this.WriteOut(Msg.get("SHELL_STARTUP_CGA"));
        }
        if (Dosbox.machine == 0) {
            this.WriteOut(Msg.get("SHELL_STARTUP_HERC"));
        }
        this.WriteOut(Msg.get("SHELL_STARTUP_END"));
        line = this.cmd.FindString("/INIT", true);
        if (line != null) {
            this.ParseLine(line);
        }
        do {
            String input_line;
            if (this.bf != null) {
                input_line = this.bf.ReadLine();
                if (input_line == null) continue;
                if (this.echo && input_line.length() > 0 && input_line.charAt(0) != '@') {
                    this.ShowPrompt();
                    this.WriteOut_NoParsing(input_line);
                    this.WriteOut_NoParsing("\n");
                }
                this.ParseLine(input_line);
                if (!this.echo) continue;
                this.WriteOut("\n");
                continue;
            }
            if (this.echo) {
                this.ShowPrompt();
            }
            if ((input_line = this.InputCommand()) == null) {
                input_line = "";
            }
            this.ParseLine(input_line);
            if (!this.echo || this.bf != null) continue;
            this.WriteOut_NoParsing("\n");
        } while (!this.exit);
    }

    void RunInternal() {
        String input_line;
        while (this.bf != null && (input_line = this.bf.ReadLine()) != null) {
            if (this.echo && input_line.charAt(0) != '@') {
                this.ShowPrompt();
                this.WriteOut_NoParsing(input_line);
                this.WriteOut_NoParsing("\n");
            }
            this.ParseLine(input_line);
        }
    }

    void ParseLine(String line) {
        Log.log(13, 2, "Parsing command line: " + line);
        if (line.startsWith("@")) {
            line = line.substring(1);
        }
        line = line.trim();
        StringRef in = new StringRef(null);
        StringRef out = new StringRef(null);
        IntRef dummy = new IntRef(0);
        IntRef dummy2 = new IntRef(0);
        LongRef bigdummy = new LongRef(0L);
        int num = 0;
        BooleanRef append = new BooleanRef();
        boolean normalstdin = false;
        boolean normalstdout = false;
        StringRef s = new StringRef(line);
        num = this.GetRedirection(s, in, out, append);
        line = s.value;
        if (num > 1) {
            Log.log_msg("SHELL:Multiple command on 1 line not supported");
        }
        if (in.value != null || out != null) {
            normalstdin = this.psp.GetFileHandle(0) != 255;
            boolean bl = normalstdout = this.psp.GetFileHandle(1) != 255;
        }
        if (in.value != null && Dos_files.DOS_OpenFile(in.value, 0, dummy)) {
            Dos_files.DOS_CloseFile(dummy.value);
            Log.log_msg("SHELL:Redirect input from " + in);
            if (normalstdin) {
                Dos_files.DOS_CloseFile(0);
            }
            Dos_files.DOS_OpenFile(in.value, 0, dummy);
        }
        if (out.value != null) {
            Log.log_msg("SHELL:Redirect output to " + out.value);
            if (normalstdout) {
                Dos_files.DOS_CloseFile(1);
            }
            if (!normalstdin && in.value == null) {
                Dos_files.DOS_OpenFile("con", 2, dummy);
            }
            boolean status = true;
            if (append.value) {
                status = Dos_files.DOS_OpenFile(out.value, 2, dummy);
                if (status) {
                    Dos_files.DOS_SeekFile(1, bigdummy, 2);
                } else {
                    status = Dos_files.DOS_CreateFile(out.value, 32, dummy);
                }
            } else {
                status = Dos_files.DOS_OpenFileExtended(out.value, 2, 32, 18, dummy, dummy2);
            }
            if (!status && normalstdout) {
                Dos_files.DOS_OpenFile("con", 2, dummy);
            }
            if (!normalstdin && in.value == null) {
                Dos_files.DOS_CloseFile(0);
            }
        }
        this.DoCommand(line);
        if (in.value != null) {
            Dos_files.DOS_CloseFile(0);
            if (normalstdin) {
                Dos_files.DOS_OpenFile("con", 2, dummy);
            }
        }
        if (out.value != null) {
            Dos_files.DOS_CloseFile(1);
            if (!normalstdin) {
                Dos_files.DOS_OpenFile("con", 2, dummy);
            }
            if (normalstdout) {
                Dos_files.DOS_OpenFile("con", 2, dummy);
            }
            if (!normalstdin) {
                Dos_files.DOS_CloseFile(0);
            }
        }
    }

    int GetRedirection(StringRef s, StringRef ifn, StringRef ofn, BooleanRef append) {
        String lr = s.value;
        StringBuffer lw = new StringBuffer();
        int num = 0;
        boolean quote = false;
        block6: while (lr.length() > 0) {
            char ch = lr.charAt(0);
            lr = lr.substring(1);
            if (quote && ch != '\"') {
                lw.append(ch);
                continue;
            }
            switch (ch) {
                case '\"': {
                    quote = !quote;
                    break;
                }
                case '>': {
                    boolean bl = append.value = lr.length() > 0 && lr.charAt(0) == '>';
                    if (append.value) {
                        lr = lr.substring(1);
                    }
                    ofn.value = lr = lr.trim();
                    while (lr.length() > 0 && lr.charAt(0) != ' ' && lr.charAt(0) != '<' && lr.charAt(0) != '|') {
                        lr = lr.substring(1);
                    }
                    if (ofn.value.length() != lr.length() && ofn.value.endsWith(":")) {
                        ofn.value = ofn.value.substring(0, ofn.value.length() - 1);
                    }
                    ofn.value = ofn.value.substring(0, ofn.value.length() - lr.length());
                    continue block6;
                }
                case '<': {
                    ifn.value = lr = lr.trim();
                    while (lr.length() > 0 && lr.charAt(0) != ' ' && lr.charAt(0) != '<' && lr.charAt(0) != '|') {
                        lr = lr.substring(1);
                    }
                    if (ifn.value.length() != lr.length() && ifn.value.endsWith(":")) {
                        ifn.value = ifn.value.substring(0, ifn.value.length() - 1);
                    }
                    ifn.value = ifn.value.substring(0, ifn.value.length() - lr.length());
                    continue block6;
                }
                case '|': {
                    ch = '\u0000';
                    ++num;
                }
            }
            lw.append(ch);
        }
        s.value = lw.toString();
        return num;
    }

    static void outc(int b) {
        byte[] c = new byte[]{(byte)b};
        IntRef n = new IntRef(1);
        Dos_files.DOS_WriteFile(1, c, n);
    }

    String InputCommand() {
        int size = 4094;
        byte[] c = new byte[1];
        IntRef n = new IntRef(1);
        int str_len = 0;
        int str_index = 0;
        IntRef len = new IntRef(0);
        boolean current_hist = false;
        byte[] line = new byte[4096];
        int it_history = 0;
        int it_completion = 0;
        block18: while (size != 0) {
            int i;
            IntRef a;
            Dos.dos.echo = false;
            while (!Dos_files.DOS_ReadFile(this.input_handle, c, n)) {
                IntRef dummy = new IntRef(0);
                Dos_files.DOS_CloseFile(this.input_handle);
                Dos_files.DOS_OpenFile("con", 2, dummy);
                Log.log(21, 2, "Reopening the input handle.This is a bug!");
            }
            if (n.value == 0) {
                size = 0;
                continue;
            }
            switch (c[0]) {
                case 0: {
                    Dos_files.DOS_ReadFile(this.input_handle, c, n);
                    switch (c[0]) {
                        case 61: {
                            if (this.l_history.size() == 0) continue block18;
                            it_history = 0;
                            if (this.l_history.size() <= 0 || ((String)this.l_history.firstElement()).length() <= str_len) continue block18;
                            String reader = ((String)this.l_history.firstElement()).substring(str_len);
                            for (int i2 = 0; i2 < reader.length(); ++i2) {
                                c[0] = (byte)reader.charAt(0);
                                line[str_index++] = (byte)reader.charAt(0);
                                Dos_files.DOS_WriteFile(1, c, n);
                            }
                            str_len = str_index = ((String)this.l_history.firstElement()).length();
                            size = 4096 - str_index - 2;
                            line[str_len] = 0;
                            continue block18;
                        }
                        case 75: {
                            if (str_index == 0) continue block18;
                            Dos_shell.outc(8);
                            --str_index;
                            continue block18;
                        }
                        case 77: {
                            if (str_index >= str_len) continue block18;
                            Dos_shell.outc(line[str_index++]);
                            continue block18;
                        }
                        case 71: {
                            while (str_index != 0) {
                                Dos_shell.outc(8);
                                --str_index;
                            }
                            continue block18;
                        }
                        case 79: {
                            while (str_index < str_len) {
                                Dos_shell.outc(line[str_index++]);
                            }
                            continue block18;
                        }
                        case 72: {
                            if (this.l_history.size() == 0 || it_history == this.l_history.size()) continue block18;
                            if (it_history == 0 && !current_hist) {
                                current_hist = true;
                                this.l_history.insertElementAt(new String(line, 0, str_len), 0);
                                ++it_history;
                            }
                            while (str_index > 0) {
                                Dos_shell.outc(8);
                                Dos_shell.outc(32);
                                Dos_shell.outc(8);
                                --str_index;
                            }
                            StringHelper.strcpy(line, (String)this.l_history.elementAt(it_history));
                            str_len = str_index = (len.value = ((String)this.l_history.elementAt(it_history)).length());
                            size = 4096 - str_index - 2;
                            Dos_files.DOS_WriteFile(1, line, len);
                            ++it_history;
                            continue block18;
                        }
                        case 80: {
                            if (this.l_history.size() == 0 || it_history == 0) continue block18;
                            if (--it_history == 0) {
                                ++it_history;
                                if (!current_hist) continue block18;
                                current_hist = false;
                                this.l_history.removeElementAt(0);
                                continue block18;
                            }
                            --it_history;
                            while (str_index > 0) {
                                Dos_shell.outc(8);
                                Dos_shell.outc(32);
                                Dos_shell.outc(8);
                                --str_index;
                            }
                            StringHelper.strcpy(line, (String)this.l_history.elementAt(it_history));
                            str_len = str_index = (len.value = ((String)this.l_history.elementAt(it_history)).length());
                            size = 4096 - str_index - 2;
                            Dos_files.DOS_WriteFile(1, line, len);
                            ++it_history;
                            continue block18;
                        }
                        case 83: {
                            if (str_index >= str_len) continue block18;
                            a = new IntRef(str_len - str_index - 1);
                            byte[] text = new byte[a.value];
                            System.arraycopy(line, str_index + 1, text, 0, a.value);
                            Dos_files.DOS_WriteFile(1, text, a);
                            Dos_shell.outc(32);
                            Dos_shell.outc(8);
                            for (i = str_index; i < str_len - 1; ++i) {
                                line[i] = line[i + 1];
                                Dos_shell.outc(8);
                            }
                            line[--str_len] = 0;
                            ++size;
                            continue block18;
                        }
                    }
                    continue block18;
                }
                case 8: {
                    if (str_index != 0) {
                        Dos_shell.outc(8);
                        int str_remain = str_len - str_index;
                        ++size;
                        if (str_remain != 0) {
                            int i3;
                            for (i3 = 0; i3 < str_remain; ++i3) {
                                line[str_index - 1 + i3] = line[str_index + i3];
                            }
                            line[--str_len] = 0;
                            for (i3 = --str_index; i3 < str_len; ++i3) {
                                Dos_shell.outc(line[i3]);
                            }
                        } else {
                            line[--str_index] = 0;
                            --str_len;
                        }
                        Dos_shell.outc(32);
                        Dos_shell.outc(8);
                        while (str_remain-- != 0) {
                            Dos_shell.outc(8);
                        }
                    }
                    if (this.l_completion.size() == 0) continue block18;
                    this.l_completion.clear();
                    continue block18;
                }
                case 10: {
                    continue block18;
                }
                case 13: {
                    Dos_shell.outc(10);
                    size = 0;
                    continue block18;
                }
                case 9: {
                    if (this.l_completion.size() != 0) {
                        if (++it_completion == this.l_completion.size()) {
                            it_completion = 0;
                        }
                    } else {
                        String mask;
                        boolean dir_only = StringHelper.toString(line).toUpperCase().startsWith("CD ");
                        String sLine = StringHelper.toString(line);
                        int p_completion_start = sLine.lastIndexOf(32);
                        if (p_completion_start >= 0) {
                            this.completion_index = ++p_completion_start;
                        } else {
                            p_completion_start = 0;
                            this.completion_index = 0;
                        }
                        int path = sLine.substring(this.completion_index).lastIndexOf(92);
                        if (path >= 0) {
                            this.completion_index += path + 1;
                        }
                        if ((path = sLine.substring(this.completion_index).lastIndexOf(47)) >= 0) {
                            this.completion_index += path + 1;
                        }
                        if (p_completion_start >= 0) {
                            mask = sLine.substring(p_completion_start);
                            int dot_pos = mask.lastIndexOf(46);
                            int bs_pos = mask.lastIndexOf(92);
                            int fs_pos = mask.lastIndexOf(47);
                            int cl_pos = mask.lastIndexOf(58);
                            mask = dot_pos - bs_pos > 0 && dot_pos - fs_pos > 0 && dot_pos - cl_pos > 0 ? mask + "*" : mask + "*.*";
                        } else {
                            mask = "*.*";
                        }
                        int save_dta = Dos.dos.dta();
                        Dos.dos.dta(Dos.dos.tables.tempdta);
                        boolean res = Dos_files.DOS_FindFirst(mask, 65527);
                        if (!res) {
                            Dos.dos.dta(save_dta);
                            continue block18;
                        }
                        Dos_DTA dta = new Dos_DTA(Dos.dos.dta());
                        StringRef name = new StringRef();
                        LongRef sz = new LongRef(0L);
                        IntRef date = new IntRef(0);
                        IntRef time = new IntRef(0);
                        ShortRef att = new ShortRef(0);
                        int extIndex = 0;
                        while (res) {
                            dta.GetResult(name, sz, date, time, att);
                            if (!name.value.equals(".") && !name.value.equals("..")) {
                                if (dir_only) {
                                    if ((att.value & 0x10) != 0) {
                                        this.l_completion.add(name.value);
                                    }
                                } else {
                                    int pos = name.value.lastIndexOf(46);
                                    String ext = null;
                                    if (pos >= 0) {
                                        ext = name.value.substring(pos + 1);
                                    }
                                    if (ext != null && (ext.equalsIgnoreCase("BAT") || ext.equalsIgnoreCase("COM") || ext.equalsIgnoreCase("EXE"))) {
                                        this.l_completion.insertElementAt(name.value, extIndex++);
                                    } else {
                                        this.l_completion.add(name.value);
                                    }
                                }
                            }
                            res = Dos_files.DOS_FindNext();
                        }
                        it_completion = 0;
                        Dos.dos.dta(save_dta);
                    }
                    if (this.l_completion.size() == 0 || ((String)this.l_completion.elementAt(it_completion)).length() == 0) continue block18;
                    while (str_index > this.completion_index) {
                        Dos_shell.outc(8);
                        Dos_shell.outc(32);
                        Dos_shell.outc(8);
                        --str_index;
                    }
                    StringHelper.strcpy(line, this.completion_index, (String)this.l_completion.elementAt(it_completion));
                    len.value = ((String)this.l_completion.elementAt(it_completion)).length();
                    str_len = str_index = this.completion_index + len.value;
                    size = 4096 - str_index - 2;
                    Dos_files.DOS_WriteFile(1, ((String)this.l_completion.elementAt(it_completion)).getBytes(), len);
                    continue block18;
                }
                case 27: {
                    Dos_shell.outc(92);
                    Dos_shell.outc(10);
                    line[0] = 0;
                    if (this.l_completion.size() != 0) {
                        this.l_completion.clear();
                    }
                    StringHelper.strcpy(line, this.InputCommand());
                    size = 0;
                    str_len = 0;
                    continue block18;
                }
            }
            if (this.l_completion.size() != 0) {
                this.l_completion.clear();
            }
            if (str_index < str_len) {
                Dos_shell.outc(32);
                a = new IntRef(str_len - str_index);
                byte[] text = new byte[a.value];
                System.arraycopy(line, str_index, text, 0, a.value);
                Dos_files.DOS_WriteFile(1, text, a);
                Dos_shell.outc(8);
                for (i = str_len; i > str_index; --i) {
                    line[i] = line[i - 1];
                    Dos_shell.outc(8);
                }
                line[++str_len] = 0;
                --size;
            }
            line[str_index] = c[0];
            if (++str_index > str_len) {
                line[str_index] = 0;
                ++str_len;
                --size;
            }
            Dos_files.DOS_WriteFile(1, c, n);
        }
        if (str_len == 0) {
            return null;
        }
        ++str_len;
        if (current_hist) {
            current_hist = false;
            this.l_history.removeElementAt(0);
        }
        String sLine = StringHelper.toString(line);
        this.l_history.insertElementAt(sLine, 0);
        it_history = 0;
        if (this.l_completion.size() != 0) {
            this.l_completion.clear();
        }
        return sLine;
    }

    void ShowPrompt() {
        char drive = (char)(Dos_files.DOS_GetDefaultDrive() + 65);
        StringRef dir = new StringRef();
        Dos_files.DOS_GetCurrentDir((short)0, dir);
        this.WriteOut(String.valueOf(drive) + ":\\" + dir.value + ">");
    }

    void DoCommand(String line) {
        int cmd_index;
        line = line.trim();
        StringBuffer cmd_buffer = new StringBuffer();
        while (line.length() > 0 && line.charAt(0) != ' ' && line.charAt(0) != '/' && line.charAt(0) != '\t' && line.charAt(0) != '=') {
            if (line.charAt(0) == '.' || line.charAt(0) == '\\') {
                cmd_index = 0;
                while (this.cmd_list[cmd_index].name != null) {
                    if (cmd_buffer.toString().equalsIgnoreCase(this.cmd_list[cmd_index].name)) {
                        this.cmd_list[cmd_index].handler.call(line);
                        return;
                    }
                    ++cmd_index;
                }
            }
            cmd_buffer.append(line.charAt(0));
            line = line.substring(1);
        }
        if (cmd_buffer.length() == 0) {
            return;
        }
        cmd_index = 0;
        while (this.cmd_list[cmd_index].name != null) {
            if (cmd_buffer.toString().equalsIgnoreCase(this.cmd_list[cmd_index].name)) {
                this.cmd_list[cmd_index].handler.call(line);
                return;
            }
            ++cmd_index;
        }
        if (this.Execute(cmd_buffer.toString(), line)) {
            return;
        }
        if (this.CheckConfig(cmd_buffer.toString(), line)) {
            return;
        }
        this.WriteOut(Msg.get("SHELL_EXECUTE_ILLEGAL_COMMAND"), new Object[]{cmd_buffer.toString()});
    }

    public boolean Execute(String name, String args) {
        String line = args;
        if (args.length() != 0 && args.charAt(0) != ' ') {
            line = ' ' + line;
        }
        if ((name.substring(1).equals(":") || name.substring(1).equals(":\\")) && StringHelper.isalpha(name.charAt(0))) {
            if (!Dos_files.DOS_SetDrive((short)(name.toUpperCase().charAt(0) - 65))) {
                this.WriteOut(Msg.get("SHELL_EXECUTE_DRIVE_NOT_FOUND"), new Object[]{new Character(name.toUpperCase().charAt(0))});
            }
            return true;
        }
        String p_fullname = this.Which(name);
        if (p_fullname == null) {
            return false;
        }
        String fullname = p_fullname;
        int extension = fullname.lastIndexOf(46);
        String sExtension = "";
        if (extension >= 0) {
            sExtension = fullname.substring(extension).toLowerCase();
        } else {
            String temp_name = fullname + ".COM";
            String temp_fullname = this.Which(temp_name);
            if (temp_fullname != null) {
                sExtension = ".com";
                fullname = temp_fullname;
            } else {
                temp_name = fullname + ".EXE";
                temp_fullname = this.Which(temp_name);
                temp_fullname = this.Which(temp_name);
                if (temp_fullname != null) {
                    sExtension = ".exe";
                    fullname = temp_fullname;
                } else {
                    temp_name = fullname + ".BAT";
                    temp_fullname = this.Which(temp_name);
                    temp_fullname = this.Which(temp_name);
                    if (temp_fullname != null) {
                        sExtension = ".bat";
                        fullname = temp_fullname;
                    } else {
                        return false;
                    }
                }
            }
        }
        if (sExtension.equalsIgnoreCase(".bat")) {
            boolean temp_echo = this.echo;
            if (this.bf != null && !this.call) {
                this.bf.close();
            }
            this.bf = new BatchFile(this, fullname, name, line);
            this.echo = temp_echo;
        } else {
            if (!sExtension.equalsIgnoreCase(".com") && !sExtension.equalsIgnoreCase(".exe")) {
                return false;
            }
            CPU_Regs.reg_esp.word(CPU_Regs.reg_esp.word() - 512);
            Dos_ParamBlock block = new Dos_ParamBlock(CPU.Segs_SSphys + CPU_Regs.reg_esp.word());
            block.Clear();
            int file_name = CPU_Regs.RealMakeSegSS(CPU_Regs.reg_esp.word() + 32);
            Memory.MEM_BlockWrite(Memory.Real2Phys(file_name), fullname, fullname.length() + 1);
            full_arguments = line;
            byte[] cmdtail = new byte[128];
            cmdtail[0] = (byte)line.length();
            StringHelper.strcpy(cmdtail, 1, line);
            cmdtail[line.length() + 1] = 13;
            Memory.MEM_BlockWrite(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 256, cmdtail, 128);
            ShortRef add = new ShortRef(0);
            String tailBuffer = StringHelper.toString(cmdtail, 1, cmdtail.length - 1);
            Dos_files.FCB_Parsename(Dos.dos.psp(), 92, (short)0, tailBuffer, add);
            Dos_files.FCB_Parsename(Dos.dos.psp(), 108, (short)0, tailBuffer.substring(add.value), add);
            block.exec.fcb1 = Memory.RealMake(Dos.dos.psp(), 92);
            block.exec.fcb2 = Memory.RealMake(Dos.dos.psp(), 108);
            block.exec.cmdtail = CPU_Regs.RealMakeSegSS(CPU_Regs.reg_esp.word() + 256);
            block.SaveData();
            CPU_Regs.reg_eax.word(19200);
            CPU_Regs.SegSet16DS(CPU.Segs_SSval);
            CPU_Regs.reg_edx.word(Memory.RealOff(file_name));
            CPU_Regs.SegSet16ES(CPU.Segs_SSval);
            CPU_Regs.reg_ebx.word(CPU_Regs.reg_esp.word());
            CPU_Regs.SETFLAGBIT(512, false);
            Callback.CALLBACK_RunRealInt(33);
            CPU_Regs.reg_esp.word(CPU_Regs.reg_esp.word() + 512);
        }
        return true;
    }

    boolean CheckConfig(String cmd_in, String line) {
        Section test = Dosbox.control.GetSectionFromProperty(cmd_in);
        if (test == null) {
            return false;
        }
        if (line != null && line.length() == 0) {
            String val = test.GetPropValue(cmd_in);
            if (!val.equals("PROP_NOT_EXIST")) {
                this.WriteOut(val + "\n");
            }
            return true;
        }
        String newcom = "z:\\config " + test.GetName() + " " + cmd_in + line;
        this.DoCommand(newcom);
        return true;
    }

    String Which(String name) {
        if (Dos_files.DOS_FileExists(name)) {
            return name;
        }
        if (Dos_files.DOS_FileExists(name + ".COM")) {
            return name + ".COM";
        }
        if (Dos_files.DOS_FileExists(name + ".EXE")) {
            return name + ".EXE";
        }
        if (Dos_files.DOS_FileExists(name + ".BAT")) {
            return name + ".BAT";
        }
        StringRef temp = new StringRef();
        if (!this.GetEnvStr("PATH", temp)) {
            return null;
        }
        if (temp.value.length() == 0) {
            return null;
        }
        int pos = temp.value.indexOf(61);
        if (pos < 0) {
            return null;
        }
        String pathenv = temp.value.substring(pos + 1);
        while (pathenv.length() > 0) {
            while (pathenv.length() > 0 && pathenv.charAt(0) == ';') {
                pathenv = pathenv.substring(1);
            }
            StringBuffer path = new StringBuffer();
            while (pathenv.length() > 0 && pathenv.charAt(0) != ';') {
                path.append(pathenv.charAt(0));
                pathenv = pathenv.substring(1);
            }
            if (path.length() <= 0) continue;
            if (path.charAt(path.length() - 1) != '\\') {
                path.append("\\");
            }
            path.append(name);
            String p = path.toString();
            if (Dos_files.DOS_FileExists(p)) {
                return p;
            }
            if (Dos_files.DOS_FileExists(p + ".COM")) {
                return p + ".COM";
            }
            if (Dos_files.DOS_FileExists(p + ".EXE")) {
                return p + ".EXE";
            }
            if (!Dos_files.DOS_FileExists(p + ".BAT")) continue;
            return p + ".BAT";
        }
        return null;
    }

    private boolean HELP(StringRef args, String command) {
        if (Dos_shell.ScanCMDBool(args, "?")) {
            this.WriteOut(Msg.get("SHELL_CMD_" + command + "_HELP"));
            String long_m = Msg.get("SHELL_CMD_" + command + "_HELP_LONG");
            this.WriteOut("\n");
            if (!long_m.equals("Message not Found!\n")) {
                this.WriteOut(long_m);
            } else {
                this.WriteOut(command + "\n");
            }
            return true;
        }
        return false;
    }

    private static String StripSpaces(String args) {
        while (args.length() > 0 && StringHelper.isspace(args.charAt(0))) {
            args = args.substring(1);
        }
        return args;
    }

    private static String StripSpaces(String args, char also) {
        while (args.length() > 0 && (StringHelper.isspace(args.charAt(0)) || args.charAt(0) == also)) {
            args = args.substring(1);
        }
        return args;
    }

    private static String StripWord(StringRef line) {
        int end_quote;
        String scan = line.value;
        if ((scan = scan.trim()).startsWith("\"") && (end_quote = scan.indexOf(34, 1)) >= 0) {
            line.value = scan.substring(end_quote + 1).trim();
            return scan.substring(1, end_quote);
        }
        for (int i = 0; i < scan.length(); ++i) {
            if (!StringHelper.isspace(scan.charAt(i))) continue;
            line.value = scan.substring(i).trim();
            return scan.substring(0, i);
        }
        line.value = "";
        return scan;
    }

    static String FormatNumber(long num) {
        long numb = num % 1000L;
        long numk = (num /= 1000L) % 1000L;
        long numm = (num /= 1000L) % 1000L;
        long numg = num /= 1000L;
        if (numg != 0L) {
            return StringHelper.sprintf("%d,%03d,%03d,%03d", new Object[]{new Long(numg), new Long(numm), new Long(numk), new Long(numb)});
        }
        if (numm != 0L) {
            return StringHelper.sprintf("%d,%03d,%03d", new Object[]{new Long(numm), new Long(numk), new Long(numb)});
        }
        if (numk != 0L) {
            return StringHelper.sprintf("%d,%03d", new Object[]{new Long(numk), new Long(numb)});
        }
        return String.valueOf(numb);
    }

    private static String ExpandDot(StringRef args) {
        if (args.value.startsWith(".")) {
            if (args.value.length() == 1) {
                return "*.*";
            }
            if (args.value.charAt(1) != '.' && args.value.charAt(1) != '\\') {
                return "*" + args.value;
            }
        }
        return args.value;
    }

    private static boolean ScanCMDBool(StringRef cmd, String check) {
        int pos = 0;
        check = "/" + check;
        while ((pos = cmd.value.toUpperCase().indexOf(check, pos)) >= 0) {
            int start = pos;
            if (cmd.value.length() != (pos += check.length()) && cmd.value.charAt(pos) != ' ' && cmd.value.charAt(pos) != '\t' && cmd.value.charAt(pos) != '/') continue;
            cmd.value = cmd.value.substring(0, start) + cmd.value.substring(pos).trim();
            return true;
        }
        return false;
    }

    private static String ScanCMDRemain(StringRef cmd) {
        int pos = cmd.value.indexOf(47);
        if (pos >= 0) {
            String scan = cmd.value.substring(pos + 1);
            StringBuffer found = new StringBuffer();
            while (scan.length() > 0 && !StringHelper.isspace(scan.charAt(0))) {
                found.append(scan.charAt(0));
                scan = scan.substring(1);
            }
            return found.toString();
        }
        return null;
    }

    void SyntaxError() {
        this.WriteOut(Msg.get("SHELL_SYNTAXERROR"));
    }

    private static class DefaultChoice
    extends Thread {
        int timeout = 0;
        byte[] choice;
        Object mutex = new Object();

        private DefaultChoice() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.mutex.wait(this.timeout * 1000);
                    Bios_keyboard.BIOS_AddKeyToBuffer(this.choice[0]);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static class copysource {
        String filename = "";
        boolean concat = false;

        copysource(String filein, boolean concatin) {
            this.filename = filein;
            this.concat = concatin;
        }

        copysource() {
        }
    }

    public static interface handler {
        public void call(String var1);
    }
}

