/*
 * Decompiled with CFR 0.152.
 */
package jdos.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache {
    private static final float hashTableLoadFactor = 0.75f;
    private LinkedHashMap map;
    private int cacheSize;

    public LRUCache(int cacheSize) {
        this.cacheSize = cacheSize;
        int hashTableCapacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.map = new LinkedHashMap(hashTableCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCache.this.cacheSize;
            }
        };
    }

    public synchronized Object get(Object key) {
        return this.map.get(key);
    }

    public synchronized void put(Object key, Object value) {
        this.map.put(key, value);
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized int usedEntries() {
        return this.map.size();
    }
}

