/*
 * Decompiled with CFR 0.152.
 */
package jdos.util;

import java.util.Arrays;

public class Ptr {
    public byte[] p;
    public int off;
    protected int start;
    public int size;

    public Ptr() {
        this.p = null;
        this.off = 0;
        this.start = 0;
        this.size = 0;
    }

    public Ptr(int size) {
        this.p = new byte[size];
        this.off = 0;
        this.start = 0;
        this.size = size;
    }

    public Ptr(byte[] p, int off) {
        this.p = p;
        this.off = off;
        this.start = off;
        this.size = p.length;
    }

    public Ptr(Ptr p, int off, int size) {
        this.p = p.p;
        this.off = off + p.off;
        this.start = off + p.off;
        this.size = size;
    }

    public Ptr(Ptr p, int off) {
        this.p = p.p;
        this.start = this.off = p.off + off;
        this.size = p.size;
    }

    public Ptr(Ptr p) {
        this.p = p.p;
        this.off = p.off;
        this.start = p.off;
        this.size = p.size;
    }

    public int dataWidth() {
        return 1;
    }

    public int get() {
        return this.get(0);
    }

    public void set(int value) {
        this.set(0, value);
    }

    public void inc() {
        this.inc(1);
    }

    public int off() {
        return this.off;
    }

    public void inc(int size) {
        this.off += size * this.dataWidth();
    }

    public int size() {
        return this.p.length - this.start;
    }

    public int used() {
        return this.off - this.start;
    }

    public static void memcpy(Ptr dest, Ptr source, int len) {
        System.arraycopy(source.p, source.off, dest.p, dest.off, len);
    }

    public static void memcpy(Ptr dest, byte[] source, int len) {
        System.arraycopy(source, 0, dest.p, dest.off, len);
    }

    public static void memcpy(byte[] dest, byte[] source, int len) {
        System.arraycopy(source, 0, dest, 0, len);
    }

    public static int memcmp(Ptr b1, byte[] b2, int len) {
        for (int i = 0; i < len; ++i) {
            if (b1.p[i + b1.off] > b2[i]) {
                return 1;
            }
            if (b1.p[i + b1.off] >= b2[i]) continue;
            return -1;
        }
        return 0;
    }

    public void clear(int len) {
        Arrays.fill(this.p, this.off, this.off + len * this.dataWidth(), (byte)0);
    }

    public void clear() {
        Arrays.fill(this.p, this.off, this.p.length, (byte)0);
    }

    public void or(int off, int mask) {
        int n = this.off + off * this.dataWidth();
        this.p[n] = (byte)(this.p[n] | mask);
    }

    public int get(int off) {
        return this.readb(off);
    }

    public void set(int off, int val) {
        this.p[this.off + off] = (byte)(val & 0xFF);
    }

    public void setPlus(int value) {
        this.set(this.get() + value);
    }

    public void setPlus(int offset, int value) {
        this.set(offset, this.get(offset) + value);
    }

    public void setInc(int val) {
        this.set(0, val);
        this.off += this.dataWidth();
    }

    public long getInc() {
        int result = this.get();
        this.off += this.dataWidth();
        return result;
    }

    public void writeb(int off, short val) {
        this.p[off * this.dataWidth() + this.off] = (byte)val;
    }

    public void writew(int off, int val) {
        off = off * this.dataWidth() + this.off;
        this.p[off] = (byte)val;
        this.p[off + 1] = (byte)(val >> 8);
    }

    public void writed(int off, long val) {
        off = off * this.dataWidth() + this.off;
        this.p[off] = (byte)val;
        this.p[off + 1] = (byte)(val >> 8);
        this.p[off + 2] = (byte)(val >> 16);
        this.p[off + 3] = (byte)(val >> 24);
    }

    public short readb(int off) {
        return (short)(this.p[off * this.dataWidth() + this.off] & 0xFF);
    }

    public int readw(int off) {
        off = off * this.dataWidth() + this.off;
        return this.p[off] & 0xFF | (this.p[off + 1] & 0xFF) << 8;
    }

    public int readd(int off) {
        off = off * this.dataWidth() + this.off;
        return this.p[off] & 0xFF | (this.p[off + 1] & 0xFF) << 8 | (this.p[off + 2] & 0xFF) << 16 | (this.p[off + 3] & 0xFF) << 24;
    }

    public void read(byte[] b) {
        System.arraycopy(this.p, this.off, b, 0, b.length);
    }

    public void read(byte[] b, int len) {
        System.arraycopy(this.p, this.off, b, 0, len);
    }

    public int read(int size, int o) {
        int off = o;
        if (size == 1) {
            return this.readb(off);
        }
        if (size == 2) {
            return this.readw(off);
        }
        if (size == 4) {
            return this.readd(off);
        }
        return 0;
    }

    public void write(int size, int o, int val) {
        int off = o;
        if (size == 1) {
            this.writeb(off, (short)val);
        } else if (size == 2) {
            this.writew(off, val);
        } else if (size == 4) {
            this.writed(off, val);
        }
    }
}

